/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.blockentity.BellRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.optifine.Config;
import net.optifine.entity.model.BellModel;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterBell
extends ModelAdapter {
    public ModelAdapterBell() {
        super(BlockEntityType.BELL, "bell", 0.0f);
    }

    @Override
    public Model makeModel() {
        return new BellModel();
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof BellModel)) {
            return null;
        }
        BellModel bellmodel = (BellModel)model;
        return modelPart.equals("body") ? bellmodel.bellBody : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"body"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model model, float shadowSize) {
        BlockEntityRenderDispatcher blockentityrenderdispatcher = Config.getMinecraft().getBlockEntityRenderDispatcher();
        BlockEntityRenderer blockentityrenderer = blockentityrenderdispatcher.getRenderer(BlockEntityType.BELL);
        if (!(blockentityrenderer instanceof BellRenderer)) {
            return null;
        }
        if (blockentityrenderer.getType() == null) {
            blockentityrenderer = new BellRenderer(blockentityrenderdispatcher.getContext());
        }
        if (!(model instanceof BellModel)) {
            Config.warn("Not a bell model: " + model);
            return null;
        }
        BellModel bellmodel = (BellModel)model;
        return bellmodel.updateRenderer(blockentityrenderer);
    }
}

