/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.optifine.Config;
import net.optifine.entity.model.ChestLargeModel;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterChestLarge
extends ModelAdapter {
    public ModelAdapterChestLarge() {
        super(BlockEntityType.CHEST, "chest_large", 0.0f);
    }

    @Override
    public Model makeModel() {
        return new ChestLargeModel();
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof ChestLargeModel)) {
            return null;
        }
        ChestLargeModel chestlargemodel = (ChestLargeModel)model;
        if (modelPart.equals("lid_left")) {
            return chestlargemodel.lid_left;
        }
        if (modelPart.equals("base_left")) {
            return chestlargemodel.base_left;
        }
        if (modelPart.equals("knob_left")) {
            return chestlargemodel.knob_left;
        }
        if (modelPart.equals("lid_right")) {
            return chestlargemodel.lid_right;
        }
        if (modelPart.equals("base_right")) {
            return chestlargemodel.base_right;
        }
        return modelPart.equals("knob_right") ? chestlargemodel.knob_right : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"lid_left", "base_left", "knob_left", "lid_right", "base_right", "knob_right"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        BlockEntityRenderDispatcher blockentityrenderdispatcher = Config.getMinecraft().getBlockEntityRenderDispatcher();
        ChestRenderer blockentityrenderer = blockentityrenderdispatcher.getRenderer(BlockEntityType.CHEST);
        if (!(blockentityrenderer instanceof ChestRenderer)) {
            return null;
        }
        if (blockentityrenderer.getType() == null) {
            blockentityrenderer = new ChestRenderer(blockentityrenderdispatcher.getContext());
        }
        if (!(modelBase instanceof ChestLargeModel)) {
            Config.warn("Not a large chest model: " + modelBase);
            return null;
        }
        ChestLargeModel chestlargemodel = (ChestLargeModel)modelBase;
        return chestlargemodel.updateRenderer(blockentityrenderer);
    }
}

