/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.ChickenRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.reflect.Reflector;

public class ModelAdapterChicken
extends ModelAdapter {
    public ModelAdapterChicken() {
        super(EntityType.CHICKEN, "chicken", 0.3f);
    }

    @Override
    public Model makeModel() {
        return new ChickenModel(ModelAdapterChicken.bakeModelLayer(ModelLayers.CHICKEN));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof ChickenModel)) {
            return null;
        }
        ChickenModel chickenmodel = (ChickenModel)model;
        if (modelPart.equals("head")) {
            return (ModelPart)Reflector.ModelChicken_ModelRenderers.getValue(chickenmodel, 0);
        }
        if (modelPart.equals("body")) {
            return (ModelPart)Reflector.ModelChicken_ModelRenderers.getValue(chickenmodel, 1);
        }
        if (modelPart.equals("right_leg")) {
            return (ModelPart)Reflector.ModelChicken_ModelRenderers.getValue(chickenmodel, 2);
        }
        if (modelPart.equals("left_leg")) {
            return (ModelPart)Reflector.ModelChicken_ModelRenderers.getValue(chickenmodel, 3);
        }
        if (modelPart.equals("right_wing")) {
            return (ModelPart)Reflector.ModelChicken_ModelRenderers.getValue(chickenmodel, 4);
        }
        if (modelPart.equals("left_wing")) {
            return (ModelPart)Reflector.ModelChicken_ModelRenderers.getValue(chickenmodel, 5);
        }
        if (modelPart.equals("bill")) {
            return (ModelPart)Reflector.ModelChicken_ModelRenderers.getValue(chickenmodel, 6);
        }
        return modelPart.equals("chin") ? (ModelPart)Reflector.ModelChicken_ModelRenderers.getValue(chickenmodel, 7) : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"head", "body", "right_leg", "left_leg", "right_wing", "left_wing", "bill", "chin"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        ChickenRenderer chickenrenderer = new ChickenRenderer(entityrenderdispatcher.getContext());
        chickenrenderer.model = (ChickenModel)modelBase;
        chickenrenderer.shadowRadius = shadowSize;
        return chickenrenderer;
    }
}

