/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.CodModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.CodRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterCod
extends ModelAdapter {
    public ModelAdapterCod() {
        super(EntityType.COD, "cod", 0.3f);
    }

    @Override
    public Model makeModel() {
        return new CodModel(ModelAdapterCod.bakeModelLayer(ModelLayers.COD));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof CodModel)) {
            return null;
        }
        CodModel codmodel = (CodModel)model;
        if (modelPart.equals("body")) {
            return codmodel.root().getChildModelDeep("body");
        }
        if (modelPart.equals("fin_back")) {
            return codmodel.root().getChildModelDeep("top_fin");
        }
        if (modelPart.equals("head")) {
            return codmodel.root().getChildModelDeep("head");
        }
        if (modelPart.equals("nose")) {
            return codmodel.root().getChildModelDeep("nose");
        }
        if (modelPart.equals("fin_right")) {
            return codmodel.root().getChildModelDeep("right_fin");
        }
        if (modelPart.equals("fin_left")) {
            return codmodel.root().getChildModelDeep("left_fin");
        }
        return modelPart.equals("tail") ? codmodel.root().getChildModelDeep("tail_fin") : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"body", "fin_back", "head", "nose", "fin_right", "fin_left", "tail"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        CodRenderer codrenderer = new CodRenderer(entityrenderdispatcher.getContext());
        codrenderer.model = (CodModel)modelBase;
        codrenderer.shadowRadius = shadowSize;
        return codrenderer;
    }
}

