/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.ConduitRenderer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.optifine.Config;
import net.optifine.entity.model.ConduitModel;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterConduit
extends ModelAdapter {
    public ModelAdapterConduit() {
        super(BlockEntityType.CONDUIT, "conduit", 0.0f);
    }

    @Override
    public Model makeModel() {
        return new ConduitModel();
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof ConduitModel)) {
            return null;
        }
        ConduitModel conduitmodel = (ConduitModel)model;
        if (modelPart.equals("eye")) {
            return conduitmodel.eye;
        }
        if (modelPart.equals("wind")) {
            return conduitmodel.wind;
        }
        if (modelPart.equals("base")) {
            return conduitmodel.base;
        }
        return modelPart.equals("cage") ? conduitmodel.cage : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"eye", "wind", "base", "cage"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        BlockEntityRenderDispatcher blockentityrenderdispatcher = Config.getMinecraft().getBlockEntityRenderDispatcher();
        BlockEntityRenderer blockentityrenderer = blockentityrenderdispatcher.getRenderer(BlockEntityType.CONDUIT);
        if (!(blockentityrenderer instanceof ConduitRenderer)) {
            return null;
        }
        if (blockentityrenderer.getType() == null) {
            blockentityrenderer = new ConduitRenderer(blockentityrenderdispatcher.getContext());
        }
        if (!(modelBase instanceof ConduitModel)) {
            Config.warn("Not a conduit model: " + modelBase);
            return null;
        }
        ConduitModel conduitmodel = (ConduitModel)modelBase;
        return conduitmodel.updateRenderer(blockentityrenderer);
    }
}

