/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.CreeperRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterCreeper
extends ModelAdapter {
    public ModelAdapterCreeper() {
        super(EntityType.CREEPER, "creeper", 0.5f);
    }

    @Override
    public Model makeModel() {
        return new CreeperModel(ModelAdapterCreeper.bakeModelLayer(ModelLayers.CREEPER));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof CreeperModel)) {
            return null;
        }
        CreeperModel creepermodel = (CreeperModel)model;
        if (modelPart.equals("head")) {
            return creepermodel.root().getChildModelDeep("head");
        }
        if (modelPart.equals("body")) {
            return creepermodel.root().getChildModelDeep("body");
        }
        if (modelPart.equals("leg1")) {
            return creepermodel.root().getChildModelDeep("right_hind_leg");
        }
        if (modelPart.equals("leg2")) {
            return creepermodel.root().getChildModelDeep("left_hind_leg");
        }
        if (modelPart.equals("leg3")) {
            return creepermodel.root().getChildModelDeep("right_front_leg");
        }
        return modelPart.equals("leg4") ? creepermodel.root().getChildModelDeep("left_front_leg") : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"head", "body", "leg1", "leg2", "leg3", "leg4"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        CreeperRenderer creeperrenderer = new CreeperRenderer(entityrenderdispatcher.getContext());
        creeperrenderer.model = (CreeperModel)modelBase;
        creeperrenderer.shadowRadius = shadowSize;
        return creeperrenderer;
    }
}

