/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EndCrystalRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.Config;
import net.optifine.entity.model.EnderCrystalModel;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterEnderCrystal
extends ModelAdapter {
    public ModelAdapterEnderCrystal() {
        this("end_crystal");
    }

    protected ModelAdapterEnderCrystal(String name) {
        super(EntityType.END_CRYSTAL, name, 0.5f);
    }

    @Override
    public Model makeModel() {
        return new EnderCrystalModel();
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof EnderCrystalModel)) {
            return null;
        }
        EnderCrystalModel endercrystalmodel = (EnderCrystalModel)model;
        if (modelPart.equals("cube")) {
            return endercrystalmodel.cube;
        }
        if (modelPart.equals("glass")) {
            return endercrystalmodel.glass;
        }
        return modelPart.equals("base") ? endercrystalmodel.base : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"cube", "glass", "base"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityrenderer = entityrenderdispatcher.getEntityRenderMap().get(EntityType.END_CRYSTAL);
        if (!(entityrenderer instanceof EndCrystalRenderer)) {
            Config.warn("Not an instance of RenderEnderCrystal: " + entityrenderer);
            return null;
        }
        EndCrystalRenderer endcrystalrenderer = (EndCrystalRenderer)entityrenderer;
        if (endcrystalrenderer.getType() == null) {
            endcrystalrenderer = new EndCrystalRenderer(entityrenderdispatcher.getContext());
        }
        if (!(modelBase instanceof EnderCrystalModel)) {
            Config.warn("Not a EnderCrystalModel model: " + modelBase);
            return null;
        }
        EnderCrystalModel endercrystalmodel = (EnderCrystalModel)modelBase;
        endcrystalrenderer = endercrystalmodel.updateRenderer(endcrystalrenderer);
        endcrystalrenderer.shadowRadius = shadowSize;
        return endcrystalrenderer;
    }
}

