/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.FoxModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.FoxRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.reflect.Reflector;

public class ModelAdapterFox
extends ModelAdapter {
    private static Map<String, Integer> mapPartFields = null;

    public ModelAdapterFox() {
        super(EntityType.FOX, "fox", 0.4f);
    }

    @Override
    public Model makeModel() {
        return new FoxModel(ModelAdapterFox.bakeModelLayer(ModelLayers.FOX));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof FoxModel)) {
            return null;
        }
        FoxModel foxmodel = (FoxModel)model;
        Map<String, Integer> map = ModelAdapterFox.getMapPartFields();
        if (map.containsKey(modelPart)) {
            int i = map.get(modelPart);
            return (ModelPart)Reflector.getFieldValue(foxmodel, Reflector.ModelFox_ModelRenderers, i);
        }
        return null;
    }

    @Override
    public String[] getModelRendererNames() {
        return ModelAdapterFox.getMapPartFields().keySet().toArray(new String[0]);
    }

    private static Map<String, Integer> getMapPartFields() {
        if (mapPartFields != null) {
            return mapPartFields;
        }
        mapPartFields = new LinkedHashMap<String, Integer>();
        mapPartFields.put("head", 0);
        mapPartFields.put("body", 1);
        mapPartFields.put("leg1", 2);
        mapPartFields.put("leg2", 3);
        mapPartFields.put("leg3", 4);
        mapPartFields.put("leg4", 5);
        mapPartFields.put("tail", 6);
        return mapPartFields;
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        FoxRenderer foxrenderer = new FoxRenderer(entityrenderdispatcher.getContext());
        foxrenderer.model = (FoxModel)modelBase;
        foxrenderer.shadowRadius = shadowSize;
        return foxrenderer;
    }
}

