/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.GhastRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.Config;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.util.StrUtils;

public class ModelAdapterGhast
extends ModelAdapter {
    public ModelAdapterGhast() {
        super(EntityType.GHAST, "ghast", 0.5f);
    }

    @Override
    public Model makeModel() {
        return new GhastModel(ModelAdapterGhast.bakeModelLayer(ModelLayers.GHAST));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof GhastModel)) {
            return null;
        }
        GhastModel ghastmodel = (GhastModel)model;
        if (modelPart.equals("body")) {
            return ghastmodel.root().getChildModelDeep("body");
        }
        String s = "tentacle";
        if (modelPart.startsWith(s)) {
            String s1 = StrUtils.removePrefix(modelPart, s);
            int i = Config.parseInt(s1, -1);
            int j = i - 1;
            return ghastmodel.root().getChildModelDeep("tentacle" + j);
        }
        return null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"body", "tentacle1", "tentacle2", "tentacle3", "tentacle4", "tentacle5", "tentacle6", "tentacle7", "tentacle8", "tentacle9"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        GhastRenderer ghastrenderer = new GhastRenderer(entityrenderdispatcher.getContext());
        ghastrenderer.model = (GhastModel)modelBase;
        ghastrenderer.shadowRadius = shadowSize;
        return ghastrenderer;
    }
}

