/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.IronGolemRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterIronGolem
extends ModelAdapter {
    public ModelAdapterIronGolem() {
        super(EntityType.IRON_GOLEM, "iron_golem", 0.5f);
    }

    @Override
    public Model makeModel() {
        return new IronGolemModel(ModelAdapterIronGolem.bakeModelLayer(ModelLayers.IRON_GOLEM));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof IronGolemModel)) {
            return null;
        }
        IronGolemModel irongolemmodel = (IronGolemModel)model;
        if (modelPart.equals("head")) {
            return irongolemmodel.root().getChilds("head");
        }
        if (modelPart.equals("body")) {
            return irongolemmodel.root().getChilds("body");
        }
        if (modelPart.equals("right_arm")) {
            return irongolemmodel.root().getChilds("right_arm");
        }
        if (modelPart.equals("left_arm")) {
            return irongolemmodel.root().getChilds("left_arm");
        }
        if (modelPart.equals("left_leg")) {
            return irongolemmodel.root().getChilds("left_leg");
        }
        return modelPart.equals("right_leg") ? irongolemmodel.root().getChilds("right_leg") : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"head", "body", "right_arm", "left_arm", "left_leg", "right_leg"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        IronGolemRenderer irongolemrenderer = new IronGolemRenderer(entityrenderdispatcher.getContext());
        irongolemrenderer.model = (IronGolemModel)modelBase;
        irongolemrenderer.shadowRadius = shadowSize;
        return irongolemrenderer;
    }
}

