/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.LlamaModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LlamaRenderer;
import net.minecraft.client.renderer.entity.layers.LlamaDecorLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.optifine.Config;
import net.optifine.entity.model.CustomEntityModels;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapterLlama;
import net.optifine.reflect.Reflector;

public class ModelAdapterLlamaDecor
extends ModelAdapterLlama {
    public ModelAdapterLlamaDecor() {
        super(EntityType.LLAMA, "llama_decor", 0.7f);
    }

    protected ModelAdapterLlamaDecor(EntityType entityType, String name, float shadowSize) {
        super(entityType, name, shadowSize);
    }

    @Override
    public Model makeModel() {
        return new LlamaModel(ModelAdapterLlamaDecor.bakeModelLayer(ModelLayers.LLAMA_DECOR));
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityType entitytype = this.getType().getLeft().get();
        EntityRenderer entityrenderer = entityrenderdispatcher.getEntityRenderMap().get(entitytype);
        if (!(entityrenderer instanceof LlamaRenderer)) {
            Config.warn("Not a RenderLlama: " + entityrenderer);
            return null;
        }
        if (entityrenderer.getType() == null) {
            LlamaRenderer llamarenderer = new LlamaRenderer(entityrenderdispatcher.getContext(), ModelLayers.LLAMA_DECOR);
            llamarenderer.model = new LlamaModel(ModelAdapterLlamaDecor.bakeModelLayer(ModelLayers.LLAMA_DECOR));
            llamarenderer.shadowRadius = 0.7f;
            entityrenderer = llamarenderer;
        }
        LlamaRenderer llamarenderer1 = (LlamaRenderer)entityrenderer;
        LlamaDecorLayer llamadecorlayer = new LlamaDecorLayer(llamarenderer1, entityrenderdispatcher.getContext().getModelSet());
        if (!Reflector.LayerLlamaDecor_model.exists()) {
            Config.warn("Field not found: LayerLlamaDecor.model");
            return null;
        }
        Reflector.LayerLlamaDecor_model.setValue(llamadecorlayer, modelBase);
        llamarenderer1.removeLayers(LlamaDecorLayer.class);
        llamarenderer1.addLayer(llamadecorlayer);
        return llamarenderer1;
    }

    @Override
    public boolean setTextureLocation(IEntityRenderer er, ResourceLocation textureLocation) {
        EntityModel model = ((LlamaRenderer)er).model;
        CustomEntityModels.setTextureTopModelRenderers(this, model, textureLocation);
        return true;
    }
}

