/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.Config;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.reflect.Reflector;

public class ModelAdapterMinecart
extends ModelAdapter {
    public ModelAdapterMinecart() {
        super(EntityType.MINECART, "minecart", 0.5f);
    }

    protected ModelAdapterMinecart(EntityType type, String name, float shadow) {
        super(type, name, shadow);
    }

    @Override
    public Model makeModel() {
        return new MinecartModel(ModelAdapterMinecart.bakeModelLayer(ModelLayers.MINECART));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof MinecartModel)) {
            return null;
        }
        MinecartModel minecartmodel = (MinecartModel)model;
        if (modelPart.equals("bottom")) {
            return minecartmodel.root().getChildModelDeep("bottom");
        }
        if (modelPart.equals("back")) {
            return minecartmodel.root().getChildModelDeep("back");
        }
        if (modelPart.equals("front")) {
            return minecartmodel.root().getChildModelDeep("front");
        }
        if (modelPart.equals("right")) {
            return minecartmodel.root().getChildModelDeep("right");
        }
        return modelPart.equals("left") ? minecartmodel.root().getChildModelDeep("left") : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"bottom", "back", "front", "right", "left"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        MinecartRenderer minecartrenderer = new MinecartRenderer(entityrenderdispatcher.getContext(), ModelLayers.MINECART);
        if (!Reflector.RenderMinecart_modelMinecart.exists()) {
            Config.warn("Field not found: RenderMinecart.modelMinecart");
            return null;
        }
        Reflector.setFieldValue(minecartrenderer, Reflector.RenderMinecart_modelMinecart, modelBase);
        minecartrenderer.shadowRadius = shadowSize;
        return minecartrenderer;
    }
}

