/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PhantomModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.PhantomRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterPhantom
extends ModelAdapter {
    private static Map<String, String> mapPartFields = null;

    public ModelAdapterPhantom() {
        super(EntityType.PHANTOM, "phantom", 0.75f);
    }

    @Override
    public Model makeModel() {
        return new PhantomModel(ModelAdapterPhantom.bakeModelLayer(ModelLayers.PHANTOM));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof PhantomModel)) {
            return null;
        }
        PhantomModel phantommodel = (PhantomModel)model;
        Map<String, String> map = ModelAdapterPhantom.getMapPartFields();
        if (map.containsKey(modelPart)) {
            String s = map.get(modelPart);
            return phantommodel.root().getChildModelDeep(s);
        }
        return null;
    }

    @Override
    public String[] getModelRendererNames() {
        return ModelAdapterPhantom.getMapPartFields().keySet().toArray(new String[0]);
    }

    private static Map<String, String> getMapPartFields() {
        if (mapPartFields != null) {
            return mapPartFields;
        }
        mapPartFields = new LinkedHashMap<String, String>();
        mapPartFields.put("body", "body");
        mapPartFields.put("head", "head");
        mapPartFields.put("left_wing", "left_wing_base");
        mapPartFields.put("left_wing_tip", "left_wing_tip");
        mapPartFields.put("right_wing", "right_wing_base");
        mapPartFields.put("right_wing_tip", "right_wing_tip");
        mapPartFields.put("tail", "tail_base");
        mapPartFields.put("tail2", "tail_tip");
        return mapPartFields;
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        PhantomRenderer phantomrenderer = new PhantomRenderer(entityrenderdispatcher.getContext());
        phantomrenderer.model = (PhantomModel)modelBase;
        phantomrenderer.shadowRadius = shadowSize;
        return phantomrenderer;
    }
}

