/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.PiglinRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapterPlayer;
import net.optifine.reflect.Reflector;

public class ModelAdapterPiglin
extends ModelAdapterPlayer {
    public ModelAdapterPiglin() {
        super(EntityType.PIGLIN, "piglin", 0.5f);
    }

    protected ModelAdapterPiglin(EntityType type, String name, float shadowSize) {
        super(type, name, shadowSize);
    }

    @Override
    public Model makeModel() {
        return new PiglinModel(ModelAdapterPiglin.bakeModelLayer(ModelLayers.PIGLIN));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (model instanceof PiglinModel) {
            PiglinModel piglinmodel = (PiglinModel)model;
            if (Reflector.ModelPiglin_ModelRenderers.exists()) {
                if (modelPart.equals("left_ear")) {
                    return piglinmodel.head.getChilds("left_ear");
                }
                if (modelPart.equals("right_ear")) {
                    return piglinmodel.head.getChilds("right_ear");
                }
            }
        }
        return super.getModelRenderer(model, modelPart);
    }

    @Override
    public String[] getModelRendererNames() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(super.getModelRendererNames()));
        list.add("left_ear");
        list.add("right_ear");
        return list.toArray(new String[list.size()]);
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        PiglinRenderer piglinrenderer = new PiglinRenderer(entityrenderdispatcher.getContext(), ModelLayers.PIGLIN, ModelLayers.PIGLIN_INNER_ARMOR, ModelLayers.PIGLIN_OUTER_ARMOR, false);
        piglinrenderer.model = (PiglinModel)modelBase;
        piglinrenderer.shadowRadius = shadowSize;
        return piglinrenderer;
    }
}

