/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PufferfishSmallModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.PufferfishRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.Config;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.reflect.Reflector;

public class ModelAdapterPufferFishSmall
extends ModelAdapter {
    public ModelAdapterPufferFishSmall() {
        super(EntityType.PUFFERFISH, "puffer_fish_small", 0.2f);
    }

    @Override
    public Model makeModel() {
        return new PufferfishSmallModel(ModelAdapterPufferFishSmall.bakeModelLayer(ModelLayers.PUFFERFISH_SMALL));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof PufferfishSmallModel)) {
            return null;
        }
        PufferfishSmallModel pufferfishsmallmodel = (PufferfishSmallModel)model;
        if (modelPart.equals("body")) {
            return pufferfishsmallmodel.root().getChildModelDeep("body");
        }
        if (modelPart.equals("eye_right")) {
            return pufferfishsmallmodel.root().getChildModelDeep("right_eye");
        }
        if (modelPart.equals("eye_left")) {
            return pufferfishsmallmodel.root().getChildModelDeep("left_eye");
        }
        if (modelPart.equals("fin_right")) {
            return pufferfishsmallmodel.root().getChildModelDeep("right_fin");
        }
        if (modelPart.equals("fin_left")) {
            return pufferfishsmallmodel.root().getChildModelDeep("left_fin");
        }
        return modelPart.equals("tail") ? pufferfishsmallmodel.root().getChildModelDeep("back_fin") : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"body", "eye_right", "eye_left", "tail", "fin_right", "fin_left"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityrenderer = entityrenderdispatcher.getEntityRenderMap().get(EntityType.PUFFERFISH);
        if (!(entityrenderer instanceof PufferfishRenderer)) {
            Config.warn("Not a PufferfishRenderer: " + entityrenderer);
            return null;
        }
        if (entityrenderer.getType() == null) {
            PufferfishRenderer pufferfishrenderer = new PufferfishRenderer(entityrenderdispatcher.getContext());
            pufferfishrenderer.shadowRadius = shadowSize;
            entityrenderer = pufferfishrenderer;
        }
        PufferfishRenderer pufferfishrenderer1 = (PufferfishRenderer)entityrenderer;
        if (!Reflector.RenderPufferfish_modelSmall.exists()) {
            Config.warn("Model field not found: RenderPufferfish.modelSmall");
            return null;
        }
        Reflector.RenderPufferfish_modelSmall.setValue(pufferfishrenderer1, modelBase);
        return pufferfishrenderer1;
    }
}

