/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.RavagerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.RavagerRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterRavager
extends ModelAdapter {
    private static Map<String, String> mapPartFields = null;

    public ModelAdapterRavager() {
        super(EntityType.RAVAGER, "ravager", 1.1f);
    }

    @Override
    public Model makeModel() {
        return new RavagerModel(ModelAdapterRavager.bakeModelLayer(ModelLayers.RAVAGER));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof RavagerModel)) {
            return null;
        }
        RavagerModel ravagermodel = (RavagerModel)model;
        Map<String, String> map = ModelAdapterRavager.getMapPartFields();
        if (map.containsKey(modelPart)) {
            String s = map.get(modelPart);
            return ravagermodel.root().getChildModelDeep(s);
        }
        return null;
    }

    @Override
    public String[] getModelRendererNames() {
        return ModelAdapterRavager.getMapPartFields().keySet().toArray(new String[0]);
    }

    private static Map<String, String> getMapPartFields() {
        if (mapPartFields != null) {
            return mapPartFields;
        }
        mapPartFields = new LinkedHashMap<String, String>();
        mapPartFields.put("head", "head");
        mapPartFields.put("jaw", "mouth");
        mapPartFields.put("body", "body");
        mapPartFields.put("leg1", "right_hind_leg");
        mapPartFields.put("leg2", "left_hind_leg");
        mapPartFields.put("leg3", "right_front_leg");
        mapPartFields.put("leg4", "left_front_leg");
        mapPartFields.put("neck", "neck");
        return mapPartFields;
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        RavagerRenderer ravagerrenderer = new RavagerRenderer(entityrenderdispatcher.getContext());
        ravagerrenderer.model = (RavagerModel)modelBase;
        ravagerrenderer.shadowRadius = shadowSize;
        return ravagerrenderer;
    }
}

