/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SheepFurModel;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.SheepRenderer;
import net.minecraft.client.renderer.entity.layers.SheepFurLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.optifine.Config;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapterQuadruped;

public class ModelAdapterSheepWool
extends ModelAdapterQuadruped {
    public ModelAdapterSheepWool() {
        super(EntityType.SHEEP, "sheep_wool", 0.7f);
    }

    @Override
    public Model makeModel() {
        return new SheepFurModel(ModelAdapterSheepWool.bakeModelLayer(ModelLayers.SHEEP_FUR));
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityrenderer = entityrenderdispatcher.getEntityRenderMap().get(EntityType.SHEEP);
        if (!(entityrenderer instanceof SheepRenderer)) {
            Config.warn("Not a RenderSheep: " + entityrenderer);
            return null;
        }
        if (entityrenderer.getType() == null) {
            SheepRenderer sheeprenderer = new SheepRenderer(entityrenderdispatcher.getContext());
            sheeprenderer.model = new SheepModel(ModelAdapterSheepWool.bakeModelLayer(ModelLayers.SHEEP_FUR));
            sheeprenderer.shadowRadius = 0.7f;
            entityrenderer = sheeprenderer;
        }
        SheepRenderer sheeprenderer1 = (SheepRenderer)entityrenderer;
        SheepFurLayer sheepfurlayer = new SheepFurLayer(sheeprenderer1, entityrenderdispatcher.getContext().getModelSet());
        sheepfurlayer.model = (SheepFurModel)modelBase;
        sheeprenderer1.removeLayers(SheepFurLayer.class);
        sheeprenderer1.addLayer(sheepfurlayer);
        return sheeprenderer1;
    }

    @Override
    public boolean setTextureLocation(IEntityRenderer er, ResourceLocation textureLocation) {
        SheepRenderer sheeprenderer = (SheepRenderer)er;
        for (SheepFurLayer sheepfurlayer : sheeprenderer.getLayers(SheepFurLayer.class)) {
            sheepfurlayer.model.locationTextureCustom = textureLocation;
        }
        return true;
    }
}

