/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ShulkerRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.reflect.Reflector;

public class ModelAdapterShulker
extends ModelAdapter {
    public ModelAdapterShulker() {
        super(EntityType.SHULKER, "shulker", 0.0f);
    }

    @Override
    public Model makeModel() {
        return new ShulkerModel(ModelAdapterShulker.bakeModelLayer(ModelLayers.SHULKER));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof ShulkerModel)) {
            return null;
        }
        ShulkerModel shulkermodel = (ShulkerModel)model;
        if (modelPart.equals("base")) {
            return (ModelPart)Reflector.ModelShulker_ModelRenderers.getValue(shulkermodel, 0);
        }
        if (modelPart.equals("lid")) {
            return (ModelPart)Reflector.ModelShulker_ModelRenderers.getValue(shulkermodel, 1);
        }
        return modelPart.equals("head") ? (ModelPart)Reflector.ModelShulker_ModelRenderers.getValue(shulkermodel, 2) : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"base", "lid", "head"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        ShulkerRenderer shulkerrenderer = new ShulkerRenderer(entityrenderdispatcher.getContext());
        shulkerrenderer.model = (ShulkerModel)modelBase;
        shulkerrenderer.shadowRadius = shadowSize;
        return shulkerrenderer;
    }
}

