/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.optifine.Config;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.reflect.Reflector;

public class ModelAdapterSign
extends ModelAdapter {
    public ModelAdapterSign() {
        super(BlockEntityType.SIGN, "sign", 0.0f);
    }

    @Override
    public Model makeModel() {
        return new SignRenderer.SignModel(ModelAdapterSign.bakeModelLayer(ModelLayers.createSignModelName(WoodType.OAK)));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof SignRenderer.SignModel)) {
            return null;
        }
        SignRenderer.SignModel signrenderer$signmodel = (SignRenderer.SignModel)model;
        if (modelPart.equals("board")) {
            return signrenderer$signmodel.root.getChildModelDeep("sign");
        }
        return modelPart.equals("stick") ? signrenderer$signmodel.root.getChildModelDeep("stick") : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"board", "stick"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        BlockEntityRenderDispatcher blockentityrenderdispatcher = Config.getMinecraft().getBlockEntityRenderDispatcher();
        BlockEntityRenderer blockentityrenderer = blockentityrenderdispatcher.getRenderer(BlockEntityType.SIGN);
        if (!(blockentityrenderer instanceof SignRenderer)) {
            return null;
        }
        if (blockentityrenderer.getType() == null) {
            blockentityrenderer = new SignRenderer(blockentityrenderdispatcher.getContext());
        }
        if (!Reflector.TileEntitySignRenderer_signModels.exists()) {
            Config.warn("Field not found: TileEntitySignRenderer.signModels");
            return null;
        }
        HashMap<WoodType, SignRenderer.SignModel> map = (HashMap<WoodType, SignRenderer.SignModel>)Reflector.getFieldValue(blockentityrenderer, Reflector.TileEntitySignRenderer_signModels);
        if (map == null) {
            Config.warn("Field not found: TileEntitySignRenderer.signModels");
            return null;
        }
        if (map instanceof ImmutableMap) {
            map = new HashMap<WoodType, SignRenderer.SignModel>(map);
            Reflector.TileEntitySignRenderer_signModels.setValue(blockentityrenderer, map);
        }
        for (WoodType woodtype : new HashSet(map.keySet())) {
            map.put(woodtype, (SignRenderer.SignModel)modelBase);
        }
        return blockentityrenderer;
    }
}

