/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.SlimeRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterSlime
extends ModelAdapter {
    public ModelAdapterSlime() {
        super(EntityType.SLIME, "slime", 0.25f);
    }

    @Override
    public Model makeModel() {
        return new SlimeModel(ModelAdapterSlime.bakeModelLayer(ModelLayers.SLIME));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof SlimeModel)) {
            return null;
        }
        SlimeModel slimemodel = (SlimeModel)model;
        if (modelPart.equals("body")) {
            return slimemodel.root().getChildModelDeep("cube");
        }
        if (modelPart.equals("left_eye")) {
            return slimemodel.root().getChildModelDeep("left_eye");
        }
        if (modelPart.equals("right_eye")) {
            return slimemodel.root().getChildModelDeep("right_eye");
        }
        return modelPart.equals("mouth") ? slimemodel.root().getChildModelDeep("mouth") : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"body", "left_eye", "right_eye", "mouth"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        SlimeRenderer slimerenderer = new SlimeRenderer(entityrenderdispatcher.getContext());
        slimerenderer.model = (SlimeModel)modelBase;
        slimerenderer.shadowRadius = shadowSize;
        return slimerenderer;
    }
}

