/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.SnowGolemRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterSnowman
extends ModelAdapter {
    public ModelAdapterSnowman() {
        super(EntityType.SNOW_GOLEM, "snow_golem", 0.5f);
    }

    @Override
    public Model makeModel() {
        return new SnowGolemModel(ModelAdapterSnowman.bakeModelLayer(ModelLayers.SNOW_GOLEM));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof SnowGolemModel)) {
            return null;
        }
        SnowGolemModel snowgolemmodel = (SnowGolemModel)model;
        if (modelPart.equals("body")) {
            return snowgolemmodel.root().getChildModelDeep("upper_body");
        }
        if (modelPart.equals("body_bottom")) {
            return snowgolemmodel.root().getChildModelDeep("lower_body");
        }
        if (modelPart.equals("head")) {
            return snowgolemmodel.root().getChildModelDeep("head");
        }
        if (modelPart.equals("right_hand")) {
            return snowgolemmodel.root().getChildModelDeep("right_arm");
        }
        return modelPart.equals("left_hand") ? snowgolemmodel.root().getChildModelDeep("left_arm") : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"body", "body_bottom", "head", "right_hand", "left_hand"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        SnowGolemRenderer snowgolemrenderer = new SnowGolemRenderer(entityrenderdispatcher.getContext());
        snowgolemrenderer.model = (SnowGolemModel)modelBase;
        snowgolemrenderer.shadowRadius = shadowSize;
        return snowgolemrenderer;
    }
}

