/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SpiderModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.SpiderRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterSpider
extends ModelAdapter {
    public ModelAdapterSpider() {
        super(EntityType.SPIDER, "spider", 1.0f);
    }

    protected ModelAdapterSpider(EntityType type, String name, float shadowSize) {
        super(type, name, shadowSize);
    }

    @Override
    public Model makeModel() {
        return new SpiderModel(ModelAdapterSpider.bakeModelLayer(ModelLayers.SPIDER));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof SpiderModel)) {
            return null;
        }
        SpiderModel spidermodel = (SpiderModel)model;
        if (modelPart.equals("head")) {
            return spidermodel.root().getChildModelDeep("head");
        }
        if (modelPart.equals("neck")) {
            return spidermodel.root().getChildModelDeep("body0");
        }
        if (modelPart.equals("body")) {
            return spidermodel.root().getChildModelDeep("body1");
        }
        if (modelPart.equals("leg1")) {
            return spidermodel.root().getChildModelDeep("right_hind_leg");
        }
        if (modelPart.equals("leg2")) {
            return spidermodel.root().getChildModelDeep("left_hind_leg");
        }
        if (modelPart.equals("leg3")) {
            return spidermodel.root().getChildModelDeep("right_middle_hind_leg");
        }
        if (modelPart.equals("leg4")) {
            return spidermodel.root().getChildModelDeep("left_middle_hind_leg");
        }
        if (modelPart.equals("leg5")) {
            return spidermodel.root().getChildModelDeep("right_middle_front_leg");
        }
        if (modelPart.equals("leg6")) {
            return spidermodel.root().getChildModelDeep("left_middle_front_leg");
        }
        if (modelPart.equals("leg7")) {
            return spidermodel.root().getChildModelDeep("right_front_leg");
        }
        return modelPart.equals("leg8") ? spidermodel.root().getChildModelDeep("left_front_leg") : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"head", "neck", "body", "leg1", "leg2", "leg3", "leg4", "leg5", "leg6", "leg7", "leg8"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        SpiderRenderer spiderrenderer = new SpiderRenderer(entityrenderdispatcher.getContext());
        spiderrenderer.model = (EntityModel)modelBase;
        spiderrenderer.shadowRadius = shadowSize;
        return spiderrenderer;
    }
}

