/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.StriderModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.StriderRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterStrider
extends ModelAdapter {
    private static Map<String, String> mapParts = ModelAdapterStrider.makeMapParts();

    public ModelAdapterStrider() {
        super(EntityType.STRIDER, "strider", 0.5f);
    }

    @Override
    public Model makeModel() {
        return new StriderModel(ModelAdapterStrider.bakeModelLayer(ModelLayers.STRIDER));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof StriderModel)) {
            return null;
        }
        StriderModel stridermodel = (StriderModel)model;
        if (mapParts.containsKey(modelPart)) {
            String s = mapParts.get(modelPart);
            return stridermodel.root().getChildModelDeep(s);
        }
        return null;
    }

    @Override
    public String[] getModelRendererNames() {
        return mapParts.keySet().toArray(new String[0]);
    }

    private static Map<String, String> makeMapParts() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("right_leg", "right_leg");
        map.put("left_leg", "left_leg");
        map.put("body", "body");
        map.put("hair_right_bottom", "right_bottom_bristle");
        map.put("hair_right_middle", "right_middle_bristle");
        map.put("hair_right_top", "right_top_bristle");
        map.put("hair_left_top", "left_top_bristle");
        map.put("hair_left_middle", "left_middle_bristle");
        map.put("hair_left_bottom", "left_bottom_bristle");
        return map;
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        StriderRenderer striderrenderer = new StriderRenderer(entityrenderdispatcher.getContext());
        striderrenderer.model = (StriderModel)modelBase;
        striderrenderer.shadowRadius = shadowSize;
        return striderrenderer;
    }
}

