/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.optifine.Config;
import net.optifine.entity.model.ChestModel;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterTrappedChest
extends ModelAdapter {
    public ModelAdapterTrappedChest() {
        super(BlockEntityType.TRAPPED_CHEST, "trapped_chest", 0.0f);
    }

    @Override
    public Model makeModel() {
        return new ChestModel();
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof ChestModel)) {
            return null;
        }
        ChestModel chestmodel = (ChestModel)model;
        if (modelPart.equals("lid")) {
            return chestmodel.lid;
        }
        if (modelPart.equals("base")) {
            return chestmodel.base;
        }
        return modelPart.equals("knob") ? chestmodel.knob : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"lid", "base", "knob"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        BlockEntityRenderDispatcher blockentityrenderdispatcher = Config.getMinecraft().getBlockEntityRenderDispatcher();
        ChestRenderer blockentityrenderer = blockentityrenderdispatcher.getRenderer(BlockEntityType.TRAPPED_CHEST);
        if (!(blockentityrenderer instanceof ChestRenderer)) {
            return null;
        }
        if (blockentityrenderer.getType() == null) {
            blockentityrenderer = new ChestRenderer(blockentityrenderdispatcher.getContext());
        }
        if (!(modelBase instanceof ChestModel)) {
            Config.warn("Not a chest model: " + modelBase);
            return null;
        }
        ChestModel chestmodel = (ChestModel)modelBase;
        return chestmodel.updateRenderer(blockentityrenderer);
    }
}

