/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.TridentModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ThrownTridentRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.Config;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.reflect.Reflector;

public class ModelAdapterTrident
extends ModelAdapter {
    public ModelAdapterTrident() {
        super(EntityType.TRIDENT, "trident", 0.0f);
    }

    @Override
    public Model makeModel() {
        return new TridentModel(ModelAdapterTrident.bakeModelLayer(ModelLayers.TRIDENT));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        ModelPart modelpart;
        if (!(model instanceof TridentModel)) {
            return null;
        }
        TridentModel tridentmodel = (TridentModel)model;
        if (modelPart.equals("body") && (modelpart = (ModelPart)Reflector.ModelTrident_root.getValue(tridentmodel)) != null) {
            return modelpart.getChildModelDeep("pole");
        }
        return null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"body"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        ThrownTridentRenderer throwntridentrenderer = new ThrownTridentRenderer(entityrenderdispatcher.getContext());
        if (!Reflector.RenderTrident_modelTrident.exists()) {
            Config.warn("Field not found: RenderTrident.modelTrident");
            return null;
        }
        Reflector.setFieldValue(throwntridentrenderer, Reflector.RenderTrident_modelTrident, modelBase);
        throwntridentrenderer.shadowRadius = shadowSize;
        return throwntridentrenderer;
    }
}

