/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.TropicalFishModelB;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.Config;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.reflect.Reflector;

public class ModelAdapterTropicalFishB
extends ModelAdapter {
    public ModelAdapterTropicalFishB() {
        super(EntityType.TROPICAL_FISH, "tropical_fish_b", 0.2f);
    }

    public ModelAdapterTropicalFishB(EntityType entityType, String name, float shadowSize) {
        super(entityType, name, shadowSize);
    }

    @Override
    public Model makeModel() {
        return new TropicalFishModelB(ModelAdapterTropicalFishB.bakeModelLayer(ModelLayers.TROPICAL_FISH_LARGE));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof TropicalFishModelB)) {
            return null;
        }
        TropicalFishModelB tropicalfishmodelb = (TropicalFishModelB)model;
        if (modelPart.equals("body")) {
            return tropicalfishmodelb.root().getChildModelDeep("body");
        }
        if (modelPart.equals("tail")) {
            return tropicalfishmodelb.root().getChildModelDeep("tail");
        }
        if (modelPart.equals("fin_right")) {
            return tropicalfishmodelb.root().getChildModelDeep("right_fin");
        }
        if (modelPart.equals("fin_left")) {
            return tropicalfishmodelb.root().getChildModelDeep("left_fin");
        }
        if (modelPart.equals("fin_top")) {
            return tropicalfishmodelb.root().getChildModelDeep("top_fin");
        }
        return modelPart.equals("fin_bottom") ? tropicalfishmodelb.root().getChildModelDeep("bottom_fin") : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"body", "tail", "fin_right", "fin_left", "fin_top", "fin_bottom"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityrenderer = entityrenderdispatcher.getEntityRenderMap().get(EntityType.TROPICAL_FISH);
        if (!(entityrenderer instanceof TropicalFishRenderer)) {
            Config.warn("Not a TropicalFishRenderer: " + entityrenderer);
            return null;
        }
        if (entityrenderer.getType() == null) {
            TropicalFishRenderer tropicalfishrenderer = new TropicalFishRenderer(entityrenderdispatcher.getContext());
            tropicalfishrenderer.shadowRadius = shadowSize;
            entityrenderer = tropicalfishrenderer;
        }
        TropicalFishRenderer tropicalfishrenderer1 = (TropicalFishRenderer)entityrenderer;
        if (!Reflector.RenderTropicalFish_modelB.exists()) {
            Config.warn("Model field not found: RenderTropicalFish.modelB");
            return null;
        }
        Reflector.RenderTropicalFish_modelB.setValue(tropicalfishrenderer1, modelBase);
        return tropicalfishrenderer1;
    }
}

