/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.VexModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.VexRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.Config;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapterBiped;
import net.optifine.reflect.Reflector;

public class ModelAdapterVex
extends ModelAdapterBiped {
    public ModelAdapterVex() {
        super(EntityType.VEX, "vex", 0.3f);
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof VexModel)) {
            return null;
        }
        ModelPart modelpart = super.getModelRenderer(model, modelPart);
        if (modelpart != null) {
            return modelpart;
        }
        VexModel vexmodel = (VexModel)model;
        if (modelPart.equals("left_wing")) {
            return (ModelPart)Reflector.getFieldValue(vexmodel, Reflector.ModelVex_leftWing);
        }
        return modelPart.equals("right_wing") ? (ModelPart)Reflector.getFieldValue(vexmodel, Reflector.ModelVex_rightWing) : null;
    }

    @Override
    public String[] getModelRendererNames() {
        Object[] astring = super.getModelRendererNames();
        return (String[])Config.addObjectsToArray(astring, new String[]{"left_wing", "right_wing"});
    }

    @Override
    public Model makeModel() {
        return new VexModel(ModelAdapterVex.bakeModelLayer(ModelLayers.VEX));
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        VexRenderer vexrenderer = new VexRenderer(entityrenderdispatcher.getContext());
        vexrenderer.model = (VexModel)modelBase;
        vexrenderer.shadowRadius = shadowSize;
        return vexrenderer;
    }
}

