/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.entity.EntityType;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;

public class ModelAdapterVillager
extends ModelAdapter {
    public ModelAdapterVillager() {
        super(EntityType.VILLAGER, "villager", 0.5f);
    }

    protected ModelAdapterVillager(EntityType type, String name, float shadowSize) {
        super(type, name, shadowSize);
    }

    @Override
    public Model makeModel() {
        return new VillagerModel(ModelAdapterVillager.bakeModelLayer(ModelLayers.VILLAGER));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof VillagerModel)) {
            return null;
        }
        VillagerModel villagermodel = (VillagerModel)model;
        if (modelPart.equals("head")) {
            return villagermodel.root().getChildModelDeep("head");
        }
        if (modelPart.equals("headwear")) {
            return villagermodel.root().getChildModelDeep("hat");
        }
        if (modelPart.equals("headwear2")) {
            return villagermodel.root().getChildModelDeep("hat_rim");
        }
        if (modelPart.equals("body")) {
            return villagermodel.root().getChildModelDeep("body");
        }
        if (modelPart.equals("bodywear")) {
            return villagermodel.root().getChildModelDeep("jacket");
        }
        if (modelPart.equals("arms")) {
            return villagermodel.root().getChildModelDeep("arms");
        }
        if (modelPart.equals("right_leg")) {
            return villagermodel.root().getChildModelDeep("right_leg");
        }
        if (modelPart.equals("left_leg")) {
            return villagermodel.root().getChildModelDeep("left_leg");
        }
        return modelPart.equals("nose") ? villagermodel.root().getChildModelDeep("nose") : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"head", "headwear", "headwear2", "body", "bodywear", "arms", "right_leg", "left_leg", "nose"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        ReloadableResourceManager reloadableresourcemanager = (ReloadableResourceManager)Minecraft.getInstance().getResourceManager();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        VillagerRenderer villagerrenderer = new VillagerRenderer(entityrenderdispatcher.getContext());
        villagerrenderer.model = (VillagerModel)modelBase;
        villagerrenderer.shadowRadius = shadowSize;
        return villagerrenderer;
    }
}

