/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.WitherSkullRenderer;
import net.minecraft.world.entity.EntityType;
import net.optifine.Config;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.reflect.Reflector;

public class ModelAdapterWitherSkull
extends ModelAdapter {
    public ModelAdapterWitherSkull() {
        super(EntityType.WITHER_SKULL, "wither_skull", 0.0f);
    }

    @Override
    public Model makeModel() {
        return new SkullModel(ModelAdapterWitherSkull.bakeModelLayer(ModelLayers.WITHER_SKULL));
    }

    @Override
    public ModelPart getModelRenderer(Model model, String modelPart) {
        if (!(model instanceof SkullModel)) {
            return null;
        }
        SkullModel skullmodel = (SkullModel)model;
        return modelPart.equals("head") ? (ModelPart)Reflector.ModelSkull_head.getValue(skullmodel) : null;
    }

    @Override
    public String[] getModelRendererNames() {
        return new String[]{"head"};
    }

    @Override
    public IEntityRenderer makeEntityRender(Model modelBase, float shadowSize) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        WitherSkullRenderer witherskullrenderer = new WitherSkullRenderer(entityrenderdispatcher.getContext());
        if (!Reflector.RenderWitherSkull_model.exists()) {
            Config.warn("Field not found: RenderWitherSkull_model");
            return null;
        }
        Reflector.setFieldValue(witherskullrenderer, Reflector.RenderWitherSkull_model, modelBase);
        witherskullrenderer.shadowRadius = shadowSize;
        return witherskullrenderer;
    }
}

