/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.optifine.Config;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.IRenderResolver;
import net.optifine.entity.model.anim.ModelVariableFloat;
import net.optifine.entity.model.anim.ModelVariableType;
import net.optifine.entity.model.anim.RenderResolverEntity;
import net.optifine.entity.model.anim.RenderResolverTileEntity;
import net.optifine.expr.IExpression;
import net.optifine.util.Either;

public class ModelResolver
implements IModelResolver {
    private ModelAdapter modelAdapter;
    private Model model;
    private CustomModelRenderer[] customModelRenderers;
    private ModelPart thisModelRenderer;
    private ModelPart partModelRenderer;
    private IRenderResolver renderResolver;

    public ModelResolver(ModelAdapter modelAdapter, Model model, CustomModelRenderer[] customModelRenderers) {
        this.modelAdapter = modelAdapter;
        this.model = model;
        this.customModelRenderers = customModelRenderers;
        Either<EntityType, BlockEntityType> either = modelAdapter.getType();
        this.renderResolver = either.getRight().isPresent() ? new RenderResolverTileEntity() : new RenderResolverEntity();
    }

    @Override
    public IExpression getExpression(String name) {
        ModelVariableFloat iexpression = this.getModelVariable(name);
        if (iexpression != null) {
            return iexpression;
        }
        IExpression iexpression1 = this.renderResolver.getParameter(name);
        return iexpression1 != null ? iexpression1 : null;
    }

    @Override
    public ModelPart getModelRenderer(String name) {
        if (name == null) {
            return null;
        }
        if (name.indexOf(":") >= 0) {
            String[] astring = Config.tokenize(name, ":");
            ModelPart modelpart3 = this.getModelRenderer(astring[0]);
            int j = 1;
            while (j < astring.length) {
                String s = astring[j];
                ModelPart modelpart4 = modelpart3.getChildDeep(s);
                if (modelpart4 == null) {
                    return null;
                }
                modelpart3 = modelpart4;
                ++j;
            }
            return modelpart3;
        }
        if (this.thisModelRenderer != null && name.equals("this")) {
            return this.thisModelRenderer;
        }
        if (this.partModelRenderer != null && name.equals("part")) {
            return this.partModelRenderer;
        }
        ModelPart modelpart = this.modelAdapter.getModelRenderer(this.model, name);
        if (modelpart != null) {
            return modelpart;
        }
        int i = 0;
        while (i < this.customModelRenderers.length) {
            CustomModelRenderer custommodelrenderer = this.customModelRenderers[i];
            ModelPart modelpart1 = custommodelrenderer.getModelRenderer();
            if (name.equals(modelpart1.getId())) {
                return modelpart1;
            }
            ModelPart modelpart2 = modelpart1.getChildDeep(name);
            if (modelpart2 != null) {
                return modelpart2;
            }
            ++i;
        }
        return null;
    }

    @Override
    public ModelVariableFloat getModelVariable(String name) {
        String[] astring = Config.tokenize(name, ".");
        if (astring.length != 2) {
            return null;
        }
        String s = astring[0];
        String s1 = astring[1];
        ModelPart modelpart = this.getModelRenderer(s);
        if (modelpart == null) {
            return null;
        }
        ModelVariableType modelvariabletype = ModelVariableType.parse(s1);
        return modelvariabletype == null ? null : new ModelVariableFloat(name, modelpart, modelvariabletype);
    }

    public void setPartModelRenderer(ModelPart partModelRenderer) {
        this.partModelRenderer = partModelRenderer;
    }

    public void setThisModelRenderer(ModelPart thisModelRenderer) {
        this.thisModelRenderer = thisModelRenderer;
    }
}

