/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.optifine.Config;
import net.optifine.gui.GuiButtonOF;
import net.optifine.gui.GuiScreenOF;

public class GuiMessage
extends GuiScreenOF {
    private Screen parentScreen;
    private Component messageLine1;
    private Component messageLine2;
    private final List<FormattedCharSequence> listLines2 = Lists.newArrayList();
    protected String confirmButtonText;
    private int ticksUntilEnable;

    public GuiMessage(Screen parentScreen, String line1, String line2) {
        super(new TranslatableComponent("of.options.detailsTitle"));
        this.parentScreen = parentScreen;
        this.messageLine1 = new TextComponent(line1);
        this.messageLine2 = new TextComponent(line2);
        this.confirmButtonText = I18n.a("gui.done", new Object[0]);
    }

    @Override
    public void init() {
        this.addRenderableWidget(new GuiButtonOF(0, this.width / 2 - 100, this.height / 6 + 96, this.confirmButtonText));
        this.listLines2.clear();
        this.listLines2.addAll(this.minecraft.font.split(this.messageLine2, this.width - 50));
    }

    @Override
    protected void actionPerformed(AbstractWidget button) {
        Config.getMinecraft().setScreen(this.parentScreen);
    }

    @Override
    public void render(PoseStack matrixStackIn, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(matrixStackIn);
        GuiMessage.drawCenteredString(matrixStackIn, this.fontRenderer, this.messageLine1, this.width / 2, 70, 0xFFFFFF);
        int i = 90;
        for (FormattedCharSequence formattedcharsequence : this.listLines2) {
            GuiMessage.drawCenteredString(matrixStackIn, this.fontRenderer, formattedcharsequence, this.width / 2, i, 0xFFFFFF);
            i += 9;
        }
        super.render(matrixStackIn, mouseX, mouseY, partialTicks);
    }

    public void setButtonDelay(int ticksUntilEnable) {
        this.ticksUntilEnable = ticksUntilEnable;
        for (Button button : this.getButtonList()) {
            button.active = false;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (--this.ticksUntilEnable == 0) {
            for (Button button : this.getButtonList()) {
                button.active = true;
            }
        }
    }
}

