/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.FullscreenResolutionProgressOption;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.TextComponent;
import net.optifine.gui.GuiButtonOF;
import net.optifine.gui.GuiScreenOF;
import net.optifine.gui.TooltipManager;
import net.optifine.gui.TooltipProviderOptions;

public class GuiOtherSettingsOF
extends GuiScreenOF {
    private Screen prevScreen;
    private Options settings;
    private TooltipManager tooltipManager = new TooltipManager(this, new TooltipProviderOptions());

    public GuiOtherSettingsOF(Screen guiscreen, Options gamesettings) {
        super(new TextComponent(I18n.a("of.options.otherTitle", new Object[0])));
        this.prevScreen = guiscreen;
        this.settings = gamesettings;
    }

    @Override
    public void init() {
        this.clearWidgets();
        FullscreenResolutionProgressOption option = new FullscreenResolutionProgressOption(this.minecraft.getWindow());
        Option[] optionArray = new Option[14];
        optionArray[0] = Option.LAGOMETER;
        optionArray[1] = Option.PROFILER;
        optionArray[2] = Option.SHOW_FPS;
        optionArray[3] = Option.ADVANCED_TOOLTIPS;
        optionArray[4] = Option.WEATHER;
        optionArray[5] = Option.TIME;
        optionArray[6] = Option.USE_FULLSCREEN;
        optionArray[7] = Option.AUTOSAVE_TICKS;
        optionArray[8] = Option.SCREENSHOT_SIZE;
        optionArray[9] = Option.SHOW_GL_ERRORS;
        optionArray[10] = Option.TELEMETRY;
        optionArray[12] = option;
        Option[] aoption = optionArray;
        int i = 0;
        while (i < aoption.length) {
            Option option1 = aoption[i];
            if (option1 != null) {
                int j = this.width / 2 - 155 + i % 2 * 160;
                int k = this.height / 6 + 21 * (i / 2) - 12;
                AbstractWidget abstractwidget = this.addRenderableWidget(option1.createButton(this.minecraft.options, j, k, 150));
                if (option1 == option) {
                    abstractwidget.setWidth(310);
                }
            }
            ++i;
        }
        this.addRenderableWidget(new GuiButtonOF(210, this.width / 2 - 100, this.height / 6 + 168 + 11 - 44, I18n.a("of.options.other.reset", new Object[0])));
        this.addRenderableWidget(new GuiButtonOF(200, this.width / 2 - 100, this.height / 6 + 168 + 11, I18n.a("gui.done", new Object[0])));
    }

    @Override
    protected void actionPerformed(AbstractWidget guiElement) {
        if (guiElement instanceof GuiButtonOF) {
            GuiButtonOF guibuttonof = (GuiButtonOF)guiElement;
            if (guibuttonof.active) {
                if (guibuttonof.id == 200) {
                    this.minecraft.options.save();
                    this.minecraft.getWindow().changeFullscreenVideoMode();
                    this.minecraft.setScreen(this.prevScreen);
                }
                if (guibuttonof.id == 210) {
                    this.minecraft.options.save();
                    String s = I18n.a("of.message.other.reset", new Object[0]);
                    ConfirmScreen confirmscreen = new ConfirmScreen(this::confirmResult, new TextComponent(s), new TextComponent(""));
                    this.minecraft.setScreen(confirmscreen);
                }
            }
        }
    }

    @Override
    public void removed() {
        this.minecraft.options.save();
        this.minecraft.getWindow().changeFullscreenVideoMode();
        super.removed();
    }

    public void confirmResult(boolean flag) {
        if (flag) {
            this.minecraft.options.resetSettings();
        }
        this.minecraft.setScreen(this);
    }

    @Override
    public void render(PoseStack matrixStackIn, int x, int y, float partialTicks) {
        this.renderBackground(matrixStackIn);
        GuiOtherSettingsOF.drawCenteredString(matrixStackIn, this.fontRenderer, this.title, this.width / 2, 15, 0xFFFFFF);
        super.render(matrixStackIn, x, y, partialTicks);
        this.tooltipManager.drawTooltips(matrixStackIn, x, y, this.getButtonList());
    }
}

