/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import net.minecraft.client.Option;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.optifine.Lang;
import net.optifine.gui.IOptionControl;
import net.optifine.gui.TooltipProvider;

public class TooltipProviderOptions
implements TooltipProvider {
    @Override
    public Rectangle getTooltipBounds(Screen guiScreen, int x, int y) {
        int i = guiScreen.width / 2 - 150;
        int j = guiScreen.height / 6 - 7;
        if (y <= j + 98) {
            j += 105;
        }
        int k = i + 150 + 150;
        int l = j + 84 + 10;
        return new Rectangle(i, j, k - i, l - j);
    }

    @Override
    public boolean isRenderBorder() {
        return false;
    }

    @Override
    public String[] getTooltipLines(AbstractWidget btn, int width) {
        if (!(btn instanceof IOptionControl)) {
            return null;
        }
        IOptionControl ioptioncontrol = (IOptionControl)((Object)btn);
        Option option = ioptioncontrol.getControlOption();
        return option == null ? null : TooltipProviderOptions.getTooltipLines(option.getResourceKey());
    }

    public static String[] getTooltipLines(String key) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < 10) {
            String s = String.valueOf(key) + ".tooltip." + (i + 1);
            String s1 = Lang.get(s, null);
            if (s1 == null) break;
            list.add(s1);
            ++i;
        }
        return list.size() <= 0 ? null : list.toArray(new String[list.size()]);
    }
}

