/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.optifine.BetterGrass;
import net.optifine.Config;
import net.optifine.ConnectedTextures;
import net.optifine.NaturalTextures;
import net.optifine.SmartLeaves;
import net.optifine.render.RenderEnv;
import net.optifine.render.RenderTypes;

public class BlockModelCustomizer {
    private static final List<BakedQuad> NO_QUADS = ImmutableList.of();

    public static BakedModel getRenderModel(BakedModel modelIn, BlockState stateIn, RenderEnv renderEnv) {
        if (renderEnv.isSmartLeaves()) {
            modelIn = SmartLeaves.getLeavesModel(modelIn, stateIn);
        }
        return modelIn;
    }

    public static List<BakedQuad> getRenderQuads(List<BakedQuad> quads, BlockAndTintGetter worldIn, BlockState stateIn, BlockPos posIn, Direction enumfacing, RenderType layer, long rand, RenderEnv renderEnv) {
        if (enumfacing != null) {
            if (renderEnv.isSmartLeaves() && SmartLeaves.isSameLeaves(worldIn.getBlockState(posIn.relative(enumfacing)), stateIn)) {
                return NO_QUADS;
            }
            if (!renderEnv.isBreakingAnimation(quads) && Config.isBetterGrass()) {
                quads = BetterGrass.getFaceQuads(worldIn, stateIn, posIn, enumfacing, quads);
            }
        }
        List<BakedQuad> list = renderEnv.getListQuadsCustomizer();
        list.clear();
        int i = 0;
        while (i < quads.size()) {
            BakedQuad bakedquad = quads.get(i);
            BakedQuad[] abakedquad = BlockModelCustomizer.getRenderQuads(bakedquad, worldIn, stateIn, posIn, enumfacing, rand, renderEnv);
            if (i == 0 && quads.size() == 1 && abakedquad.length == 1 && abakedquad[0] == bakedquad && bakedquad.getQuadEmissive() == null) {
                return quads;
            }
            int j = 0;
            while (j < abakedquad.length) {
                BakedQuad bakedquad1 = abakedquad[j];
                list.add(bakedquad1);
                if (bakedquad1.getQuadEmissive() != null) {
                    renderEnv.getListQuadsOverlay(BlockModelCustomizer.getEmissiveLayer(layer)).addQuad(bakedquad1.getQuadEmissive(), stateIn);
                    renderEnv.setOverlaysRendered(true);
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    private static RenderType getEmissiveLayer(RenderType layer) {
        return layer != null && layer != RenderTypes.SOLID ? layer : RenderTypes.CUTOUT_MIPPED;
    }

    private static BakedQuad[] getRenderQuads(BakedQuad quad, BlockAndTintGetter worldIn, BlockState stateIn, BlockPos posIn, Direction enumfacing, long rand, RenderEnv renderEnv) {
        BakedQuad[] abakedquad;
        if (renderEnv.isBreakingAnimation(quad)) {
            return renderEnv.getArrayQuadsCtm(quad);
        }
        BakedQuad bakedquad = quad;
        if (Config.isConnectedTextures() && ((abakedquad = ConnectedTextures.getConnectedTexture(worldIn, stateIn, posIn, quad, renderEnv)).length != 1 || abakedquad[0] != quad)) {
            return abakedquad;
        }
        if (Config.isNaturalTextures() && (quad = NaturalTextures.getNaturalTexture(posIn, quad)) != bakedquad) {
            return renderEnv.getArrayQuadsCtm(quad);
        }
        return renderEnv.getArrayQuadsCtm(quad);
    }
}

