/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import net.optifine.Config;
import net.optifine.model.BakedQuadRetextured;
import net.optifine.model.ModelUtils;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;
    private static final Random RANDOM = new Random(0L);

    public static BakedModel makeModelCube(String spriteName, int tintIndex) {
        TextureAtlasSprite textureatlassprite = Config.getTextureMap().getUploadedSprite(spriteName);
        return BlockModelUtils.makeModelCube(textureatlassprite, tintIndex);
    }

    public static BakedModel makeModelCube(TextureAtlasSprite sprite, int tintIndex) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        Direction[] adirection = Direction.VALUES;
        HashMap<Direction, List<BakedQuad>> map = new HashMap<Direction, List<BakedQuad>>();
        int i = 0;
        while (i < adirection.length) {
            Direction direction = adirection[i];
            ArrayList<BakedQuad> list1 = new ArrayList<BakedQuad>();
            list1.add(BlockModelUtils.makeBakedQuad(direction, sprite, tintIndex));
            map.put(direction, list1);
            ++i;
        }
        ItemOverrides itemoverrides = ItemOverrides.EMPTY;
        SimpleBakedModel bakedmodel = new SimpleBakedModel(list, map, true, true, true, sprite, ItemTransforms.NO_TRANSFORMS, itemoverrides);
        return bakedmodel;
    }

    public static BakedModel joinModelsCube(BakedModel modelBase, BakedModel modelAdd) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        list.addAll(modelBase.getQuads(null, null, RANDOM));
        list.addAll(modelAdd.getQuads(null, null, RANDOM));
        Direction[] adirection = Direction.VALUES;
        HashMap<Direction, List<BakedQuad>> map = new HashMap<Direction, List<BakedQuad>>();
        int i = 0;
        while (i < adirection.length) {
            Direction direction = adirection[i];
            ArrayList<BakedQuad> list1 = new ArrayList<BakedQuad>();
            list1.addAll(modelBase.getQuads(null, direction, RANDOM));
            list1.addAll(modelAdd.getQuads(null, direction, RANDOM));
            map.put(direction, list1);
            ++i;
        }
        boolean flag = modelBase.useAmbientOcclusion();
        boolean flag1 = modelBase.isCustomRenderer();
        TextureAtlasSprite textureatlassprite = modelBase.getParticleIcon();
        ItemTransforms itemtransforms = modelBase.getTransforms();
        ItemOverrides itemoverrides = modelBase.getOverrides();
        SimpleBakedModel bakedmodel = new SimpleBakedModel(list, map, flag, flag1, true, textureatlassprite, itemtransforms, itemoverrides);
        return bakedmodel;
    }

    public static BakedQuad makeBakedQuad(Direction facing, TextureAtlasSprite sprite, int tintIndex) {
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f1 = new Vector3f(16.0f, 16.0f, 16.0f);
        BlockFaceUV blockfaceuv = new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        BlockElementFace blockelementface = new BlockElementFace(facing, tintIndex, "#" + facing.getSerializedName(), blockfaceuv);
        BlockModelRotation blockmodelrotation = BlockModelRotation.X0_Y0;
        BlockElementRotation blockelementrotation = null;
        boolean flag = true;
        ResourceLocation resourcelocation = sprite.getName();
        FaceBakery facebakery = new FaceBakery();
        return facebakery.bakeQuad(vector3f, vector3f1, blockelementface, sprite, facing, blockmodelrotation, blockelementrotation, flag, resourcelocation);
    }

    public static BakedModel makeModel(String modelName, String spriteOldName, String spriteNewName) {
        TextureAtlas textureatlas = Config.getTextureMap();
        TextureAtlasSprite textureatlassprite = textureatlas.getUploadedSprite(spriteOldName);
        TextureAtlasSprite textureatlassprite1 = textureatlas.getUploadedSprite(spriteNewName);
        return BlockModelUtils.makeModel(modelName, textureatlassprite, textureatlassprite1);
    }

    public static BakedModel makeModel(String modelName, TextureAtlasSprite spriteOld, TextureAtlasSprite spriteNew) {
        if (spriteOld != null && spriteNew != null) {
            ModelManager modelmanager = Config.getModelManager();
            if (modelmanager == null) {
                return null;
            }
            ModelResourceLocation modelresourcelocation = new ModelResourceLocation(modelName, "");
            BakedModel bakedmodel = modelmanager.getModel(modelresourcelocation);
            if (bakedmodel != null && bakedmodel != modelmanager.getMissingModel()) {
                BakedModel bakedmodel1 = ModelUtils.duplicateModel(bakedmodel);
                Direction[] adirection = Direction.VALUES;
                int i = 0;
                while (i < adirection.length) {
                    Direction direction = adirection[i];
                    List<BakedQuad> list = bakedmodel1.getQuads(null, direction, RANDOM);
                    BlockModelUtils.replaceTexture(list, spriteOld, spriteNew);
                    ++i;
                }
                List<BakedQuad> list1 = bakedmodel1.getQuads(null, null, RANDOM);
                BlockModelUtils.replaceTexture(list1, spriteOld, spriteNew);
                return bakedmodel1;
            }
            return null;
        }
        return null;
    }

    private static void replaceTexture(List<BakedQuad> quads, TextureAtlasSprite spriteOld, TextureAtlasSprite spriteNew) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        for (BakedQuad bakedquad : quads) {
            if (bakedquad.getSprite() == spriteOld) {
                bakedquad = new BakedQuadRetextured(bakedquad, spriteNew);
            }
            list.add(bakedquad);
        }
        quads.clear();
        quads.addAll(list);
    }

    public static void snapVertexPosition(Vector3f pos) {
        pos.set(BlockModelUtils.snapVertexCoord(pos.x()), BlockModelUtils.snapVertexCoord(pos.y()), BlockModelUtils.snapVertexCoord(pos.z()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        return x > 0.999999f && x < 1.000001f ? 1.0f : x;
    }

    public static AABB getOffsetBoundingBox(AABB aabb, BlockBehaviour.OffsetType offsetType, BlockPos pos) {
        int i = pos.getX();
        int j = pos.getZ();
        long k = (long)(i * 3129871) ^ (long)j * 116129781L;
        k = k * k * 42317861L + k * 11L;
        double d0 = ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double d1 = ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double d2 = 0.0;
        if (offsetType == BlockBehaviour.OffsetType.XYZ) {
            d2 = ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.move(d0, d2, d1);
    }
}

