/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.player;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.optifine.Config;
import net.optifine.http.HttpPipeline;
import net.optifine.http.HttpUtils;
import net.optifine.player.PlayerConfiguration;
import net.optifine.player.PlayerItemModel;
import net.optifine.player.PlayerItemParser;
import net.optifine.util.Json;

public class PlayerConfigurationParser {
    private String player = null;
    public static final String CONFIG_ITEMS = "items";
    public static final String ITEM_TYPE = "type";
    public static final String ITEM_ACTIVE = "active";

    public PlayerConfigurationParser(String player) {
        this.player = player;
    }

    public PlayerConfiguration parsePlayerConfiguration(JsonElement je) {
        PlayerConfiguration playerconfiguration;
        block7: {
            if (je == null) {
                throw new JsonParseException("JSON object is null, player: " + this.player);
            }
            JsonObject jsonobject = (JsonObject)je;
            playerconfiguration = new PlayerConfiguration();
            JsonArray jsonarray = (JsonArray)jsonobject.get(CONFIG_ITEMS);
            if (jsonarray == null) break block7;
            int i = 0;
            while (i < jsonarray.size()) {
                block8: {
                    PlayerItemModel playeritemmodel;
                    block10: {
                        NativeImage nativeimage;
                        String s;
                        JsonObject jsonobject1;
                        block9: {
                            jsonobject1 = (JsonObject)jsonarray.get(i);
                            boolean flag = Json.getBoolean(jsonobject1, ITEM_ACTIVE, true);
                            if (!flag) break block8;
                            s = Json.getString(jsonobject1, ITEM_TYPE);
                            if (s != null) break block9;
                            Config.warn("Item type is null, player: " + this.player);
                            break block8;
                        }
                        String s1 = Json.getString(jsonobject1, "model");
                        if (s1 == null) {
                            s1 = "items/" + s + "/model.cfg";
                        }
                        if ((playeritemmodel = this.downloadModel(s1)) == null) break block8;
                        if (playeritemmodel.isUsePlayerTexture()) break block10;
                        String s2 = Json.getString(jsonobject1, "texture");
                        if (s2 == null) {
                            s2 = "items/" + s + "/users/" + this.player + ".png";
                        }
                        if ((nativeimage = this.downloadTextureImage(s2)) == null) break block8;
                        playeritemmodel.setTextureImage(nativeimage);
                        ResourceLocation resourcelocation = new ResourceLocation("optifine.net", s2);
                        playeritemmodel.setTextureLocation(resourcelocation);
                    }
                    playerconfiguration.addPlayerItemModel(playeritemmodel);
                }
                ++i;
            }
        }
        return playerconfiguration;
    }

    private NativeImage downloadTextureImage(String texturePath) {
        String s = String.valueOf(HttpUtils.getPlayerItemsUrl()) + "/" + texturePath;
        try {
            byte[] abyte = HttpPipeline.get(s, Minecraft.getInstance().getProxy());
            return NativeImage.read(new ByteArrayInputStream(abyte));
        }
        catch (IOException ioexception) {
            Config.warn("Error loading item texture " + texturePath + ": " + ioexception.getClass().getName() + ": " + ioexception.getMessage());
            return null;
        }
    }

    private PlayerItemModel downloadModel(String modelPath) {
        String s = String.valueOf(HttpUtils.getPlayerItemsUrl()) + "/" + modelPath;
        try {
            byte[] abyte = HttpPipeline.get(s, Minecraft.getInstance().getProxy());
            String s1 = new String(abyte, "ASCII");
            JsonParser jsonparser = new JsonParser();
            JsonObject jsonobject = (JsonObject)jsonparser.parse(s1);
            return PlayerItemParser.parseItemModel(jsonobject);
        }
        catch (Exception exception) {
            Config.warn("Error loading item model " + modelPath + ": " + exception.getClass().getName() + ": " + exception.getMessage());
            return null;
        }
    }
}

