/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.reflect;

import com.mojang.math.Vector3f;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.optifine.Log;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorClass;
import net.optifine.reflect.ReflectorConstructor;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.StrUtils;

public class ReflectorForge {
    public static Object EVENT_RESULT_ALLOW = Reflector.getFieldValue(Reflector.Event_Result_ALLOW);
    public static Object EVENT_RESULT_DENY = Reflector.getFieldValue(Reflector.Event_Result_DENY);
    public static Object EVENT_RESULT_DEFAULT = Reflector.getFieldValue(Reflector.Event_Result_DEFAULT);
    public static final boolean FORGE_ENTITY_CAN_UPDATE = Reflector.IForgeEntity_canUpdate.exists();

    public static void putLaunchBlackboard(String key, Object value) {
        Map map = (Map)Reflector.getFieldValue(Reflector.Launch_blackboard);
        if (map != null) {
            map.put(key, value);
        }
    }

    public static InputStream getOptiFineResourceStream(String path) {
        if (!Reflector.OptiFineResourceLocator.exists()) {
            return null;
        }
        path = StrUtils.removePrefix(path, "/");
        return (InputStream)Reflector.call(Reflector.OptiFineResourceLocator_getOptiFineResourceStream, path);
    }

    public static ReflectorClass getReflectorClassOptiFineResourceLocator() {
        String s = "optifine.OptiFineResourceLocator";
        Object object = System.getProperties().get(String.valueOf(s) + ".class");
        if (object instanceof Class) {
            Class oclass = (Class)object;
            return new ReflectorClass(oclass);
        }
        return new ReflectorClass(s);
    }

    public static int getLightEmission(BlockState stateIn, BlockAndTintGetter worldIn, BlockPos posIn) {
        return Reflector.IForgeBlockState_getLightEmission.exists() ? Reflector.callInt(stateIn, Reflector.IForgeBlockState_getLightEmission, worldIn, posIn) : stateIn.getLightEmission();
    }

    public static MapItemSavedData getMapData(ItemStack stack, Level world) {
        if (Reflector.ForgeHooksClient.exists()) {
            MapItem mapitem = (MapItem)stack.getItem();
            return MapItem.getSavedData(stack, world);
        }
        return MapItem.getSavedData(stack, world);
    }

    public static String[] getForgeModIds() {
        if (!Reflector.ModList.exists()) {
            return new String[0];
        }
        Object object = Reflector.ModList_get.call(new Object[0]);
        List list = (List)Reflector.getFieldValue(object, Reflector.ModList_mods);
        if (list == null) {
            return new String[0];
        }
        ArrayList<String> list1 = new ArrayList<String>();
        for (Object object1 : list) {
            String s;
            if (!Reflector.ModContainer.isInstance(object1) || (s = Reflector.callString(object1, Reflector.ModContainer_getModId, new Object[0])) == null || s.equals("minecraft") || s.equals("forge")) continue;
            list1.add(s);
        }
        String[] astring = list1.toArray(new String[list1.size()]);
        return astring;
    }

    public static boolean canDisableShield(ItemStack itemstack, ItemStack itemstack1, Player entityplayer, Mob entityLiving) {
        return Reflector.IForgeItemStack_canDisableShield.exists() ? Reflector.callBoolean(itemstack, Reflector.IForgeItemStack_canDisableShield, itemstack1, entityplayer, entityLiving) : itemstack.getItem() instanceof AxeItem;
    }

    public static Button makeButtonMods(TitleScreen guiMainMenu, int yIn, int rowHeightIn) {
        return !Reflector.ModListScreen_Constructor.exists() ? null : new Button(guiMainMenu.width / 2 - 100, yIn + rowHeightIn * 2, 98, 20, new TranslatableComponent("fml.menu.mods"), button -> {
            Screen screen = (Screen)Reflector.ModListScreen_Constructor.newInstance(guiMainMenu);
            Minecraft.getInstance().setScreen(screen);
        });
    }

    public static void setForgeLightPipelineEnabled(boolean value) {
        if (Reflector.ForgeConfig_Client_forgeLightPipelineEnabled.exists()) {
            ReflectorForge.setConfigClientBoolean(Reflector.ForgeConfig_Client_forgeLightPipelineEnabled, value);
        }
    }

    public static boolean getForgeUseCombinedDepthStencilAttachment() {
        return Reflector.ForgeConfig_Client_useCombinedDepthStencilAttachment.exists() ? ReflectorForge.getConfigClientBoolean(Reflector.ForgeConfig_Client_useCombinedDepthStencilAttachment, false) : false;
    }

    public static boolean getConfigClientBoolean(ReflectorField configField, boolean def) {
        if (!configField.exists()) {
            return def;
        }
        Object object = Reflector.ForgeConfig_CLIENT.getValue();
        if (object == null) {
            return def;
        }
        Object object1 = Reflector.getFieldValue(object, configField);
        return object1 == null ? def : Reflector.callBoolean(object1, Reflector.ForgeConfigSpec_ConfigValue_get, new Object[0]);
    }

    private static void setConfigClientBoolean(ReflectorField clientField, boolean value) {
        Object object1;
        Object object;
        if (clientField.exists() && (object = Reflector.ForgeConfig_CLIENT.getValue()) != null && (object1 = Reflector.getFieldValue(object, clientField)) != null) {
            Supplier<Boolean> supplier = new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return value;
                }
            };
            Reflector.setFieldValue(object1, Reflector.ForgeConfigSpec_ConfigValue_defaultSupplier, supplier);
            Object object2 = Reflector.getFieldValue(object1, Reflector.ForgeConfigSpec_ConfigValue_spec);
            if (object2 != null) {
                Reflector.setFieldValue(object2, Reflector.ForgeConfigSpec_childConfig, null);
            }
            Log.dbg("Set ForgeConfig.CLIENT." + clientField.getTargetField().getName() + "=" + value);
        }
    }

    public static boolean canUpdate(Entity entity) {
        return FORGE_ENTITY_CAN_UPDATE ? Reflector.callBoolean(entity, Reflector.IForgeEntity_canUpdate, new Object[0]) : true;
    }

    public static boolean isDamageable(Item item, ItemStack stack) {
        return Reflector.IForgeItem_isDamageable1.exists() ? Reflector.callBoolean(item, Reflector.IForgeItem_isDamageable1, stack) : item.canBeDepleted();
    }

    public static void fillNormal(int[] faceData, Direction facing) {
        Vector3f vector3f = ReflectorForge.getVertexPos(faceData, 3);
        Vector3f vector3f1 = ReflectorForge.getVertexPos(faceData, 1);
        Vector3f vector3f2 = ReflectorForge.getVertexPos(faceData, 2);
        Vector3f vector3f3 = ReflectorForge.getVertexPos(faceData, 0);
        vector3f.sub(vector3f1);
        vector3f2.sub(vector3f3);
        vector3f2.cross(vector3f);
        vector3f2.normalize();
        int i = (byte)Math.round(vector3f2.x() * 127.0f) & 0xFF;
        int j = (byte)Math.round(vector3f2.y() * 127.0f) & 0xFF;
        int k = (byte)Math.round(vector3f2.z() * 127.0f) & 0xFF;
        int l = i | j << 8 | k << 16;
        int i1 = faceData.length / 4;
        int j1 = 0;
        while (j1 < 4) {
            faceData[j1 * i1 + 7] = l;
            ++j1;
        }
    }

    private static Vector3f getVertexPos(int[] data, int vertex) {
        int i = data.length / 4;
        int j = vertex * i;
        float f = Float.intBitsToFloat(data[j]);
        float f1 = Float.intBitsToFloat(data[j + 1]);
        float f2 = Float.intBitsToFloat(data[j + 2]);
        return new Vector3f(f, f1, f2);
    }

    public static void postModLoaderEvent(ReflectorConstructor constr, Object ... params) {
        Object object = Reflector.newInstance(constr, params);
        if (object != null) {
            ReflectorForge.postModLoaderEvent(object);
        }
    }

    public static void postModLoaderEvent(Object event) {
        Object object;
        if (event != null && (object = Reflector.ModLoader_get.call(new Object[0])) != null) {
            Reflector.callVoid(object, Reflector.ModLoader_postEvent, event);
        }
    }
}

