/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;

public class RenderStateManager {
    private static boolean cacheEnabled;
    private static final RenderStateShard[] PENDING_CLEAR_STATES;

    static {
        PENDING_CLEAR_STATES = new RenderStateShard[RenderType.getCountRenderStates()];
    }

    public static void setupRenderStates(List<RenderStateShard> renderStates) {
        if (cacheEnabled) {
            RenderStateManager.setupCached(renderStates);
        } else {
            int i = 0;
            while (i < renderStates.size()) {
                RenderStateShard renderstateshard = renderStates.get(i);
                renderstateshard.setupRenderState();
                ++i;
            }
        }
    }

    public static void clearRenderStates(List<RenderStateShard> renderStates) {
        if (cacheEnabled) {
            RenderStateManager.clearCached(renderStates);
        } else {
            int i = 0;
            while (i < renderStates.size()) {
                RenderStateShard renderstateshard = renderStates.get(i);
                renderstateshard.clearRenderState();
                ++i;
            }
        }
    }

    private static void setupCached(List<RenderStateShard> renderStates) {
        int i = 0;
        while (i < renderStates.size()) {
            RenderStateShard renderstateshard = renderStates.get(i);
            RenderStateManager.setupCached(renderstateshard, i);
            ++i;
        }
    }

    private static void clearCached(List<RenderStateShard> renderStates) {
        int i = 0;
        while (i < renderStates.size()) {
            RenderStateShard renderstateshard = renderStates.get(i);
            RenderStateManager.clearCached(renderstateshard, i);
            ++i;
        }
    }

    private static void setupCached(RenderStateShard state, int index) {
        RenderStateShard renderstateshard = PENDING_CLEAR_STATES[index];
        if (renderstateshard != null) {
            if (state == renderstateshard) {
                RenderStateManager.PENDING_CLEAR_STATES[index] = null;
                return;
            }
            renderstateshard.clearRenderState();
            RenderStateManager.PENDING_CLEAR_STATES[index] = null;
        }
        state.setupRenderState();
    }

    private static void clearCached(RenderStateShard state, int index) {
        RenderStateShard renderstateshard = PENDING_CLEAR_STATES[index];
        if (renderstateshard != null) {
            renderstateshard.clearRenderState();
        }
        RenderStateManager.PENDING_CLEAR_STATES[index] = state;
    }

    public static void enableCache() {
        if (!cacheEnabled) {
            cacheEnabled = true;
            Arrays.fill(PENDING_CLEAR_STATES, null);
        }
    }

    public static void disableCache() {
        if (cacheEnabled) {
            cacheEnabled = false;
            int i = 0;
            while (i < PENDING_CLEAR_STATES.length) {
                RenderStateShard renderstateshard = PENDING_CLEAR_STATES[i];
                if (renderstateshard != null) {
                    renderstateshard.clearRenderState();
                }
                ++i;
            }
            Arrays.fill(PENDING_CLEAR_STATES, null);
        }
    }
}

