/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.server.packs.resources.ResourceManager;
import net.optifine.shaders.SMCLog;
import net.optifine.shaders.Shaders;
import org.apache.commons.io.IOUtils;

public class SimpleShaderTexture
extends AbstractTexture {
    private String texturePath;

    public SimpleShaderTexture(String texturePath) {
        this.texturePath = texturePath;
    }

    @Override
    public void load(ResourceManager resourceManager) throws IOException {
        this.releaseId();
        InputStream inputstream = Shaders.getShaderPackResourceStream(this.texturePath);
        if (inputstream == null) {
            throw new FileNotFoundException("Shader texture not found: " + this.texturePath);
        }
        try {
            NativeImage nativeimage = NativeImage.read(inputstream);
            TextureMetadataSection texturemetadatasection = SimpleShaderTexture.loadTextureMetadataSection(this.texturePath, new TextureMetadataSection(false, false));
            TextureUtil.prepareImage(this.getId(), nativeimage.getWidth(), nativeimage.getHeight());
            nativeimage.upload(0, 0, 0, 0, 0, nativeimage.getWidth(), nativeimage.getHeight(), texturemetadatasection.isBlur(), texturemetadatasection.isClamp(), false, true);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
    }

    public static TextureMetadataSection loadTextureMetadataSection(String texturePath, TextureMetadataSection def) {
        String s = String.valueOf(texturePath) + ".mcmeta";
        String s1 = "texture";
        InputStream inputstream = Shaders.getShaderPackResourceStream(s);
        if (inputstream != null) {
            TextureMetadataSection texturemetadatasection1;
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream));
            try {
                JsonObject jsonobject = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
                JsonObject jsonobject1 = jsonobject.getAsJsonObject(s1);
                if (jsonobject1 == null) {
                    TextureMetadataSection textureMetadataSection = def;
                    return textureMetadataSection;
                }
                TextureMetadataSection texturemetadatasection = TextureMetadataSection.SERIALIZER.fromJson(jsonobject1);
                if (texturemetadatasection == null) {
                    TextureMetadataSection textureMetadataSection = def;
                    return textureMetadataSection;
                }
                try {
                    texturemetadatasection1 = texturemetadatasection;
                }
                catch (RuntimeException runtimeexception) {
                    SMCLog.warning("Error reading metadata: " + s);
                    SMCLog.warning(String.valueOf(runtimeexception.getClass().getName()) + ": " + runtimeexception.getMessage());
                    TextureMetadataSection textureMetadataSection = def;
                    return textureMetadataSection;
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)bufferedreader);
                IOUtils.closeQuietly((InputStream)inputstream);
            }
            return texturemetadatasection1;
        }
        return def;
    }
}

