/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.gui.GuiButtonShaderOption;
import net.optifine.shaders.gui.GuiShaderOptions;

public class GuiSliderShaderOption
extends GuiButtonShaderOption {
    private float sliderValue = 1.0f;
    public boolean dragging;
    private ShaderOption shaderOption = null;

    public GuiSliderShaderOption(int buttonId, int x, int y, int w, int h, ShaderOption shaderOption, String text) {
        super(buttonId, x, y, w, h, shaderOption, text);
        this.shaderOption = shaderOption;
        this.sliderValue = shaderOption.getIndexNormalized();
        this.setMessage(GuiShaderOptions.getButtonText(shaderOption, this.width));
    }

    @Override
    protected int getYImage(boolean p_getYImage_1_) {
        return 0;
    }

    @Override
    protected void renderBg(PoseStack matrixStackIn, Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            if (this.dragging && !Screen.hasShiftDown()) {
                this.sliderValue = (float)(mouseX - (this.x + 4)) / (float)(this.width - 8);
                this.sliderValue = Mth.clamp(this.sliderValue, 0.0f, 1.0f);
                this.shaderOption.setIndexNormalized(this.sliderValue);
                this.sliderValue = this.shaderOption.getIndexNormalized();
                this.setMessage(GuiShaderOptions.getButtonText(this.shaderOption, this.width));
            }
            mc.getTextureManager().bindForSetup(WIDGETS_LOCATION);
            GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            int i = (this.isHoveredOrFocused() ? 2 : 1) * 20;
            this.blit(matrixStackIn, this.x + (int)(this.sliderValue * (float)(this.width - 8)), this.y, 0, 46 + i, 4, 20);
            this.blit(matrixStackIn, this.x + (int)(this.sliderValue * (float)(this.width - 8)) + 4, this.y, 196, 46 + i, 4, 20);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            this.sliderValue = (float)(mouseX - (double)(this.x + 4)) / (float)(this.width - 8);
            this.sliderValue = Mth.clamp(this.sliderValue, 0.0f, 1.0f);
            this.shaderOption.setIndexNormalized(this.sliderValue);
            this.setMessage(GuiShaderOptions.getButtonText(this.shaderOption, this.width));
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
        return true;
    }

    @Override
    public void valueChanged() {
        this.sliderValue = this.shaderOption.getIndexNormalized();
    }

    @Override
    public boolean isSwitchable() {
        return false;
    }
}

