/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.uniform;

import java.util.ArrayList;
import java.util.Map;
import net.optifine.expr.IExpression;
import net.optifine.expr.IExpressionCached;
import net.optifine.shaders.uniform.CustomUniform;

public class CustomUniforms {
    private CustomUniform[] uniforms;
    private IExpressionCached[] expressionsCached;

    public CustomUniforms(CustomUniform[] uniforms, Map<String, IExpression> mapExpressions) {
        this.uniforms = uniforms;
        ArrayList<IExpressionCached> list = new ArrayList<IExpressionCached>();
        for (String s : mapExpressions.keySet()) {
            IExpression iexpression = mapExpressions.get(s);
            if (!(iexpression instanceof IExpressionCached)) continue;
            IExpressionCached iexpressioncached = (IExpressionCached)((Object)iexpression);
            list.add(iexpressioncached);
        }
        this.expressionsCached = list.toArray(new IExpressionCached[list.size()]);
    }

    public void setProgram(int program) {
        int i = 0;
        while (i < this.uniforms.length) {
            CustomUniform customuniform = this.uniforms[i];
            customuniform.setProgram(program);
            ++i;
        }
    }

    public void update() {
        this.resetCache();
        int i = 0;
        while (i < this.uniforms.length) {
            CustomUniform customuniform = this.uniforms[i];
            customuniform.update();
            ++i;
        }
    }

    private void resetCache() {
        int i = 0;
        while (i < this.expressionsCached.length) {
            IExpressionCached iexpressioncached = this.expressionsCached[i];
            iexpressioncached.reset();
            ++i;
        }
    }

    public void reset() {
        int i = 0;
        while (i < this.uniforms.length) {
            CustomUniform customuniform = this.uniforms[i];
            customuniform.reset();
            ++i;
        }
    }
}

