/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.uniform;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.optifine.expr.ConstantFloat;
import net.optifine.expr.IExpression;
import net.optifine.expr.IExpressionResolver;
import net.optifine.shaders.SMCLog;
import net.optifine.shaders.uniform.ShaderParameterBool;
import net.optifine.shaders.uniform.ShaderParameterFloat;
import net.optifine.shaders.uniform.ShaderParameterIndexed;
import net.optifine.util.BiomeUtils;

public class ShaderExpressionResolver
implements IExpressionResolver {
    private Map<String, IExpression> mapExpressions = new HashMap<String, IExpression>();

    public ShaderExpressionResolver(Map<String, IExpression> map) {
        this.registerExpressions();
        for (String s : map.keySet()) {
            IExpression iexpression = map.get(s);
            this.registerExpression(s, iexpression);
        }
    }

    private void registerExpressions() {
        ShaderParameterFloat[] ashaderparameterfloat = ShaderParameterFloat.values();
        int i = 0;
        while (i < ashaderparameterfloat.length) {
            ShaderParameterFloat shaderparameterfloat = ashaderparameterfloat[i];
            this.addParameterFloat(this.mapExpressions, shaderparameterfloat);
            ++i;
        }
        ShaderParameterBool[] ashaderparameterbool = ShaderParameterBool.values();
        int k = 0;
        while (k < ashaderparameterbool.length) {
            ShaderParameterBool shaderparameterbool = ashaderparameterbool[k];
            this.mapExpressions.put(shaderparameterbool.getName(), shaderparameterbool);
            ++k;
        }
        for (ResourceLocation resourcelocation : BiomeUtils.getLocations()) {
            String s = resourcelocation.getPath().trim();
            s = "BIOME_" + s.toUpperCase().replace(' ', '_');
            int j = BiomeUtils.getId(resourcelocation);
            ConstantFloat iexpression = new ConstantFloat(j);
            this.registerExpression(s, iexpression);
        }
        Biome.BiomeCategory[] abiome$biomecategory = Biome.BiomeCategory.values();
        int l = 0;
        while (l < abiome$biomecategory.length) {
            Biome.BiomeCategory biome$biomecategory = abiome$biomecategory[l];
            String s1 = "CAT_" + biome$biomecategory.getSerializedName().toUpperCase();
            ConstantFloat iexpression1 = new ConstantFloat(l);
            this.registerExpression(s1, iexpression1);
            ++l;
        }
        Biome.Precipitation[] abiome$precipitation = Biome.Precipitation.values();
        int i1 = 0;
        while (i1 < abiome$precipitation.length) {
            Biome.Precipitation biome$precipitation = abiome$precipitation[i1];
            String s2 = "PPT_" + biome$precipitation.getSerializedName().toUpperCase();
            ConstantFloat iexpression2 = new ConstantFloat(i1);
            this.registerExpression(s2, iexpression2);
            ++i1;
        }
    }

    private void addParameterFloat(Map<String, IExpression> map, ShaderParameterFloat spf) {
        String[] astring = spf.getIndexNames1();
        if (astring == null) {
            map.put(spf.getName(), new ShaderParameterIndexed(spf));
        } else {
            int i = 0;
            while (i < astring.length) {
                String s = astring[i];
                String[] astring1 = spf.getIndexNames2();
                if (astring1 == null) {
                    map.put(String.valueOf(spf.getName()) + "." + s, new ShaderParameterIndexed(spf, i));
                } else {
                    int j = 0;
                    while (j < astring1.length) {
                        String s1 = astring1[j];
                        map.put(String.valueOf(spf.getName()) + "." + s + "." + s1, new ShaderParameterIndexed(spf, i, j));
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public boolean registerExpression(String name, IExpression expr) {
        if (this.mapExpressions.containsKey(name)) {
            SMCLog.warning("Expression already defined: " + name);
            return false;
        }
        this.mapExpressions.put(name, expr);
        return true;
    }

    @Override
    public IExpression getExpression(String name) {
        return this.mapExpressions.get(name);
    }

    public boolean hasExpression(String name) {
        return this.mapExpressions.containsKey(name);
    }
}

