/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.uniform;

import com.mojang.math.Matrix3f;
import java.nio.FloatBuffer;
import net.optifine.shaders.uniform.ShaderUniformBase;
import net.optifine.util.BufferUtil;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryUtil;

public class ShaderUniformM3
extends ShaderUniformBase {
    private boolean transpose;
    private FloatBuffer matrixBuffer = MemoryUtil.memAllocFloat((int)9);
    private FloatBuffer tempBuffer = MemoryUtil.memAllocFloat((int)9);

    public ShaderUniformM3(String name) {
        super(name);
    }

    public void setValue(Matrix3f matrixIn) {
        this.transpose = false;
        this.tempBuffer.clear();
        matrixIn.store(this.tempBuffer);
        this.setValue(false, this.tempBuffer);
    }

    public void setValue(boolean transpose, FloatBuffer matrix) {
        this.transpose = transpose;
        matrix.mark();
        this.matrixBuffer.clear();
        this.matrixBuffer.put(matrix);
        this.matrixBuffer.rewind();
        matrix.reset();
        int i = this.getLocation();
        if (i >= 0) {
            ShaderUniformM3.flushRenderBuffers();
            GL20.glUniformMatrix3fv((int)i, (boolean)transpose, (FloatBuffer)this.matrixBuffer);
            this.checkGLError();
        }
    }

    public float getValue(int row, int col) {
        int i = this.transpose ? col * 3 + row : row * 3 + col;
        return this.matrixBuffer.get(i);
    }

    @Override
    protected void onProgramSet(int program) {
    }

    @Override
    protected void resetValue() {
        BufferUtil.fill(this.matrixBuffer, 0.0f);
    }
}

