/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.uniform;

import com.mojang.math.Matrix4f;
import java.nio.FloatBuffer;
import net.optifine.shaders.uniform.ShaderUniformBase;
import net.optifine.util.BufferUtil;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryUtil;

public class ShaderUniformM4
extends ShaderUniformBase {
    private boolean transpose;
    private FloatBuffer matrixBuffer = MemoryUtil.memAllocFloat((int)16);
    private FloatBuffer tempBuffer = MemoryUtil.memAllocFloat((int)16);

    public ShaderUniformM4(String name) {
        super(name);
    }

    public void setValue(Matrix4f matrixIn) {
        this.transpose = false;
        this.tempBuffer.clear();
        matrixIn.store(this.tempBuffer);
        this.setValue(false, this.tempBuffer);
    }

    public void setValue(boolean transpose, FloatBuffer matrix) {
        this.transpose = transpose;
        matrix.mark();
        this.matrixBuffer.clear();
        this.matrixBuffer.put(matrix);
        this.matrixBuffer.rewind();
        matrix.reset();
        int i = this.getLocation();
        if (i >= 0) {
            ShaderUniformM4.flushRenderBuffers();
            GL20.glUniformMatrix4fv((int)i, (boolean)transpose, (FloatBuffer)this.matrixBuffer);
            this.checkGLError();
        }
    }

    public float getValue(int row, int col) {
        int i = this.transpose ? col * 4 + row : row * 4 + col;
        return this.matrixBuffer.get(i);
    }

    @Override
    protected void onProgramSet(int program) {
    }

    @Override
    protected void resetValue() {
        BufferUtil.fill(this.matrixBuffer, 0.0f);
    }
}

