/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.optifine.Config;
import net.optifine.render.RenderEnv;

public class BlockUtils {
    private static final ThreadLocal<RenderSideCacheKey> threadLocalKey = ThreadLocal.withInitial(() -> new RenderSideCacheKey(null, null, null));
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> threadLocalMap = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(200){

            protected void rehash(int p_rehash_1_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });

    public static boolean shouldSideBeRendered(BlockState blockStateIn, BlockGetter blockReaderIn, BlockPos blockPosIn, Direction facingIn, RenderEnv renderEnv) {
        BlockPos blockpos = blockPosIn.relative(facingIn);
        BlockState blockstate = blockReaderIn.getBlockState(blockpos);
        if (blockstate.isCacheOpaqueCube()) {
            return false;
        }
        if (blockStateIn.skipRendering(blockstate, facingIn)) {
            return false;
        }
        return blockstate.canOcclude() ? BlockUtils.shouldSideBeRenderedCached(blockStateIn, blockReaderIn, blockPosIn, facingIn, renderEnv, blockstate, blockpos) : true;
    }

    public static boolean shouldSideBeRenderedCached(BlockState blockStateIn, BlockGetter blockReaderIn, BlockPos blockPosIn, Direction facingIn, RenderEnv renderEnv, BlockState stateNeighbourIn, BlockPos posNeighbourIn) {
        long i = (long)blockStateIn.getBlockStateId() << 36 | (long)stateNeighbourIn.getBlockStateId() << 4 | (long)facingIn.ordinal();
        Long2ByteLinkedOpenHashMap long2bytelinkedopenhashmap = renderEnv.getRenderSideMap();
        byte b0 = long2bytelinkedopenhashmap.getAndMoveToFirst(i);
        if (b0 != 0) {
            return b0 > 0;
        }
        VoxelShape voxelshape = blockStateIn.getFaceOcclusionShape(blockReaderIn, blockPosIn, facingIn);
        if (voxelshape.isEmpty()) {
            return true;
        }
        VoxelShape voxelshape1 = stateNeighbourIn.getFaceOcclusionShape(blockReaderIn, posNeighbourIn, facingIn.getOpposite());
        boolean flag = Shapes.joinIsNotEmpty(voxelshape, voxelshape1, BooleanOp.ONLY_FIRST);
        if (long2bytelinkedopenhashmap.size() > 400) {
            long2bytelinkedopenhashmap.removeLastByte();
        }
        long2bytelinkedopenhashmap.putAndMoveToFirst(i, (byte)(flag ? 1 : -1));
        return flag;
    }

    public static int getBlockId(Block block) {
        return Registry.BLOCK.getId(block);
    }

    public static Block getBlock(ResourceLocation loc) {
        return !Registry.BLOCK.containsKey(loc) ? null : Registry.BLOCK.get(loc);
    }

    public static int getMetadata(BlockState blockState) {
        Block block = blockState.getBlock();
        StateDefinition<Block, BlockState> statedefinition = block.getStateDefinition();
        ImmutableList<BlockState> list = statedefinition.getPossibleStates();
        return list.indexOf(blockState);
    }

    public static int getMetadataCount(Block block) {
        StateDefinition<Block, BlockState> statedefinition = block.getStateDefinition();
        ImmutableList<BlockState> list = statedefinition.getPossibleStates();
        return list.size();
    }

    public static BlockState getBlockState(Block block, int metadata) {
        StateDefinition<Block, BlockState> statedefinition = block.getStateDefinition();
        ImmutableList<BlockState> list = statedefinition.getPossibleStates();
        return metadata >= 0 && metadata < list.size() ? (BlockState)list.get(metadata) : null;
    }

    public static List<BlockState> getBlockStates(Block block) {
        StateDefinition<Block, BlockState> statedefinition = block.getStateDefinition();
        ImmutableList<BlockState> list = statedefinition.getPossibleStates();
        return list;
    }

    public static boolean isFullCube(BlockState stateIn, BlockGetter blockReaderIn, BlockPos posIn) {
        return stateIn.isCacheOpaqueCollisionShape();
    }

    public static Collection<Property> getProperties(BlockState blockState) {
        return blockState.getProperties();
    }

    public static boolean isPropertyTrue(BlockState blockState, BooleanProperty prop) {
        Boolean obool = (Boolean)blockState.getValues().get((Object)prop);
        return Config.isTrue(obool);
    }

    public static boolean isPropertyFalse(BlockState blockState, BooleanProperty prop) {
        Boolean obool = (Boolean)blockState.getValues().get((Object)prop);
        return Config.isFalse(obool);
    }

    public static final class RenderSideCacheKey {
        private BlockState blockState1;
        private BlockState blockState2;
        private Direction facing;
        private int hashCode;

        private RenderSideCacheKey(BlockState blockState1In, BlockState blockState2In, Direction facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
        }

        private void init(BlockState blockState1In, BlockState blockState2In, Direction facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
            this.hashCode = 0;
        }

        public RenderSideCacheKey duplicate() {
            return new RenderSideCacheKey(this.blockState1, this.blockState2, this.facing);
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey blockutils$rendersidecachekey = (RenderSideCacheKey)p_equals_1_;
            return this.blockState1 == blockutils$rendersidecachekey.blockState1 && this.blockState2 == blockutils$rendersidecachekey.blockState2 && this.facing == blockutils$rendersidecachekey.facing;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 31 * this.hashCode + this.blockState1.hashCode();
                this.hashCode = 31 * this.hashCode + this.blockState2.hashCode();
                this.hashCode = 31 * this.hashCode + this.facing.hashCode();
            }
            return this.hashCode;
        }
    }
}

