/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.mojang.math.Matrix4f;
import java.nio.FloatBuffer;
import net.optifine.util.StrUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class DebugUtils {
    private static FloatBuffer floatBuffer16 = BufferUtils.createFloatBuffer((int)16);
    private static float[] floatArray16 = new float[16];

    public static String getGlModelView() {
        floatBuffer16.clear();
        GL11.glGetFloatv((int)2982, (FloatBuffer)floatBuffer16);
        floatBuffer16.get(floatArray16);
        float[] afloat = DebugUtils.transposeMat4(floatArray16);
        return DebugUtils.getMatrix4(afloat);
    }

    public static String getGlProjection() {
        floatBuffer16.clear();
        GL11.glGetFloatv((int)2983, (FloatBuffer)floatBuffer16);
        floatBuffer16.get(floatArray16);
        float[] afloat = DebugUtils.transposeMat4(floatArray16);
        return DebugUtils.getMatrix4(afloat);
    }

    private static float[] transposeMat4(float[] arr) {
        float[] afloat = new float[16];
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                afloat[i * 4 + j] = arr[j * 4 + i];
                ++j;
            }
            ++i;
        }
        return afloat;
    }

    public static String getMatrix4(Matrix4f mat) {
        mat.write(floatArray16);
        return DebugUtils.getMatrix4(floatArray16);
    }

    private static String getMatrix4(float[] fs) {
        StringBuffer stringbuffer = new StringBuffer();
        int i = 0;
        while (i < fs.length) {
            String s = String.format("%.2f", Float.valueOf(fs[i]));
            if (i > 0) {
                if (i % 4 == 0) {
                    stringbuffer.append("\n");
                } else {
                    stringbuffer.append(", ");
                }
            }
            s = StrUtils.fillLeft(s, 5, ' ');
            stringbuffer.append(s);
            ++i;
        }
        return stringbuffer.toString();
    }
}

