/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import net.minecraft.util.Mth;
import net.optifine.util.MathUtils;

public class MathUtilsTest {
    public static void main(String[] args) throws Exception {
        OPER[] amathutilstest$oper = OPER.values();
        int i = 0;
        while (i < amathutilstest$oper.length) {
            OPER mathutilstest$oper = amathutilstest$oper[i];
            MathUtilsTest.dbg("******** " + (Object)((Object)mathutilstest$oper) + " ***********");
            MathUtilsTest.test(mathutilstest$oper, false);
            ++i;
        }
    }

    private static void test(OPER oper, boolean fast) {
        double d1;
        double d0;
        Mth.fastMath = fast;
        switch (oper) {
            case SIN: 
            case COS: {
                d0 = -3.1415927410125732;
                d1 = 3.1415927410125732;
                break;
            }
            case ASIN: 
            case ACOS: {
                d0 = -1.0;
                d1 = 1.0;
                break;
            }
            default: {
                return;
            }
        }
        int i = 10;
        int j = 0;
        while (j <= i) {
            float f1;
            float f;
            double d2 = d0 + (double)j * (d1 - d0) / (double)i;
            switch (oper) {
                case SIN: {
                    f = (float)Math.sin(d2);
                    f1 = Mth.sin((float)d2);
                    break;
                }
                case COS: {
                    f = (float)Math.cos(d2);
                    f1 = Mth.cos((float)d2);
                    break;
                }
                case ASIN: {
                    f = (float)Math.asin(d2);
                    f1 = MathUtils.asin((float)d2);
                    break;
                }
                case ACOS: {
                    f = (float)Math.acos(d2);
                    f1 = MathUtils.acos((float)d2);
                    break;
                }
                default: {
                    return;
                }
            }
            MathUtilsTest.dbg(String.format("%.2f, Math: %f, Helper: %f, diff: %f", d2, Float.valueOf(f), Float.valueOf(f1), Float.valueOf(Math.abs(f - f1))));
            ++j;
        }
    }

    public static void dbg(String str) {
        System.out.println(str);
    }

    private static enum OPER {
        SIN,
        COS,
        ASIN,
        ACOS;

    }
}

