/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.mojang.blaze3d.platform.NativeImage;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.LongSupplier;
import net.optifine.Config;

public class NativeMemory {
    private static long imageAllocated = 0L;
    private static LongSupplier bufferAllocatedSupplier = NativeMemory.makeLongSupplier(new String[][]{{"sun.misc.SharedSecrets", "getJavaNioAccess", "getDirectBufferPool", "getMemoryUsed"}, {"jdk.internal.misc.SharedSecrets", "getJavaNioAccess", "getDirectBufferPool", "getMemoryUsed"}}, NativeMemory.makeDefaultAllocatedSupplier());
    private static LongSupplier bufferMaximumSupplier = NativeMemory.makeLongSupplier(new String[][]{{"sun.misc.VM", "maxDirectMemory"}, {"jdk.internal.misc.VM", "maxDirectMemory"}}, NativeMemory.makeDefaultMaximumSupplier());

    public static long getBufferAllocated() {
        return bufferAllocatedSupplier == null ? -1L : bufferAllocatedSupplier.getAsLong();
    }

    public static long getBufferMaximum() {
        return bufferMaximumSupplier == null ? -1L : bufferMaximumSupplier.getAsLong();
    }

    public static synchronized void imageAllocated(NativeImage nativeImage) {
        imageAllocated += nativeImage.getSize();
    }

    public static synchronized void imageFreed(NativeImage nativeImage) {
        imageAllocated -= nativeImage.getSize();
    }

    public static long getImageAllocated() {
        return imageAllocated;
    }

    private static BufferPoolMXBean getDirectBufferPoolMXBean() {
        for (BufferPoolMXBean bufferpoolmxbean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            if (!Config.equals(bufferpoolmxbean.getName(), "direct")) continue;
            return bufferpoolmxbean;
        }
        return null;
    }

    private static LongSupplier makeDefaultAllocatedSupplier() {
        BufferPoolMXBean bufferpoolmxbean = NativeMemory.getDirectBufferPoolMXBean();
        return bufferpoolmxbean == null ? null : new LongSupplier(){

            @Override
            public long getAsLong() {
                return bufferpoolmxbean.getMemoryUsed();
            }
        };
    }

    private static LongSupplier makeDefaultMaximumSupplier() {
        return new LongSupplier(){

            @Override
            public long getAsLong() {
                return Runtime.getRuntime().maxMemory();
            }
        };
    }

    private static LongSupplier makeLongSupplier(String[][] paths, LongSupplier defaultSupplier) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        int i = 0;
        while (i < paths.length) {
            String[] astring = paths[i];
            try {
                LongSupplier longsupplier = NativeMemory.makeLongSupplier(astring);
                if (longsupplier != null) {
                    return longsupplier;
                }
            }
            catch (Throwable throwable) {
                list.add(throwable);
            }
            ++i;
        }
        for (Throwable throwable1 : list) {
            Config.warn("(Reflector) " + throwable1.getClass().getName() + ": " + throwable1.getMessage());
        }
        return defaultSupplier;
    }

    private static LongSupplier makeLongSupplier(String[] path) throws Exception {
        if (path.length < 2) {
            return null;
        }
        Class<?> oclass = Class.forName(path[0]);
        Method method = oclass.getMethod(path[1], new Class[0]);
        method.setAccessible(true);
        Object object = null;
        int i = 2;
        while (i < path.length) {
            String s = path[i];
            object = method.invoke(object, new Object[0]);
            method = object.getClass().getMethod(s, new Class[0]);
            method.setAccessible(true);
            ++i;
        }
        Method method1 = method;
        Object object1 = object;
        return new LongSupplier(){
            private boolean disabled = false;

            @Override
            public long getAsLong() {
                if (this.disabled) {
                    return -1L;
                }
                try {
                    return (Long)method1.invoke(object1, new Object[0]);
                }
                catch (Throwable throwable) {
                    Config.warn("(Reflector) " + throwable.getClass().getName() + ": " + throwable.getMessage());
                    this.disabled = true;
                    return -1L;
                }
            }
        };
    }
}

