/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class RenderChunkUtils {
    public static int getCountBlocks(ChunkRenderDispatcher.RenderChunk renderChunk) {
        LevelChunkSection[] alevelchunksection = renderChunk.getChunk().getSections();
        if (alevelchunksection == null) {
            return 0;
        }
        int i = renderChunk.getOrigin().getY() - renderChunk.getWorld().getMinBuildHeight() >> 4;
        LevelChunkSection levelchunksection = alevelchunksection[i];
        return levelchunksection == null ? (short)0 : levelchunksection.getBlockRefCount();
    }

    public static double getRelativeBufferSize(ChunkRenderDispatcher.RenderChunk renderChunk) {
        int i = RenderChunkUtils.getCountBlocks(renderChunk);
        return RenderChunkUtils.getRelativeBufferSize(i);
    }

    public static double getRelativeBufferSize(int blockCount) {
        double d0 = (double)blockCount / 4096.0;
        double d1 = (d0 *= 0.995) * 2.0 - 1.0;
        d1 = Mth.clamp(d1, -1.0, 1.0);
        return Math.sqrt(1.0 - d1 * d1);
    }
}

