/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.resources.LegacyPackResourcesAdapter;
import net.minecraft.client.resources.PackResourcesAdapterV4;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.StrUtils;

public class ResUtils {
    public static String[] collectFiles(String prefix, String suffix) {
        return ResUtils.collectFiles(new String[]{prefix}, new String[]{suffix});
    }

    public static String[] collectFiles(String[] prefixes, String[] suffixes) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        PackResources[] apackresources = Config.getResourcePacks();
        int i = 0;
        while (i < apackresources.length) {
            PackResources packresources = apackresources[i];
            String[] astring = ResUtils.collectFiles(packresources, prefixes, suffixes, null);
            set.addAll(Arrays.asList(astring));
            ++i;
        }
        return set.toArray(new String[set.size()]);
    }

    public static String[] collectFiles(PackResources rp, String prefix, String suffix, String[] defaultPaths) {
        return ResUtils.collectFiles(rp, new String[]{prefix}, new String[]{suffix}, defaultPaths);
    }

    public static String[] collectFiles(PackResources rp, String[] prefixes, String[] suffixes) {
        return ResUtils.collectFiles(rp, prefixes, suffixes, null);
    }

    public static String[] collectFiles(PackResources rp, String[] prefixes, String[] suffixes, String[] defaultPaths) {
        if (rp instanceof VanillaPackResources) {
            return ResUtils.collectFilesFixed(rp, defaultPaths);
        }
        if (rp instanceof LegacyPackResourcesAdapter) {
            PackResources packresources = (PackResources)Reflector.getFieldValue(rp, Reflector.LegacyResourcePackWrapper_pack);
            if (packresources == null) {
                Config.warn("LegacyResourcePackWrapper base resource pack not found: " + rp);
                return new String[0];
            }
            rp = packresources;
        }
        if (rp instanceof PackResourcesAdapterV4) {
            PackResources packresources1 = (PackResources)Reflector.getFieldValue(rp, Reflector.LegacyResourcePackWrapperV4_pack);
            if (packresources1 == null) {
                Config.warn("LegacyResourcePackWrapperV4 base resource pack not found: " + rp);
                return new String[0];
            }
            rp = packresources1;
        }
        if (!(rp instanceof AbstractPackResources)) {
            Config.warn("Unknown resource pack type: " + rp);
            return new String[0];
        }
        AbstractPackResources abstractpackresources = (AbstractPackResources)rp;
        File file1 = abstractpackresources.file;
        if (file1 == null) {
            return new String[0];
        }
        if (file1.isDirectory()) {
            return ResUtils.collectFilesFolder(file1, "", prefixes, suffixes);
        }
        if (file1.isFile()) {
            return ResUtils.collectFilesZIP(file1, prefixes, suffixes);
        }
        Config.warn("Unknown resource pack file: " + file1);
        return new String[0];
    }

    private static String[] collectFilesFixed(PackResources rp, String[] paths) {
        if (paths == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < paths.length) {
            String s = paths[i];
            if (!ResUtils.isLowercase(s)) {
                Config.warn("Skipping non-lowercase path: " + s);
            } else {
                ResourceLocation resourcelocation = new ResourceLocation(s);
                if (rp.hasResource(PackType.CLIENT_RESOURCES, resourcelocation)) {
                    list.add(s);
                }
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private static String[] collectFilesFolder(File tpFile, String basePath, String[] prefixes, String[] suffixes) {
        ArrayList<String> list = new ArrayList<String>();
        String s = "assets/minecraft/";
        File[] afile = tpFile.listFiles();
        if (afile == null) {
            return new String[0];
        }
        int i = 0;
        while (i < afile.length) {
            File file1 = afile[i];
            if (file1.isFile()) {
                String s3 = String.valueOf(basePath) + file1.getName();
                if (s3.startsWith(s) && StrUtils.startsWith(s3 = s3.substring(s.length()), prefixes) && StrUtils.endsWith(s3, suffixes)) {
                    if (!ResUtils.isLowercase(s3)) {
                        Config.warn("Skipping non-lowercase path: " + s3);
                    } else {
                        list.add(s3);
                    }
                }
            } else if (file1.isDirectory()) {
                String s1 = String.valueOf(basePath) + file1.getName() + "/";
                String[] astring = ResUtils.collectFilesFolder(file1, s1, prefixes, suffixes);
                int j = 0;
                while (j < astring.length) {
                    String s2 = astring[j];
                    list.add(s2);
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private static String[] collectFilesZIP(File tpFile, String[] prefixes, String[] suffixes) {
        ArrayList<String> list = new ArrayList<String>();
        String s = "assets/minecraft/";
        try {
            ZipFile zipfile = new ZipFile(tpFile);
            Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipentry = enumeration.nextElement();
                String s1 = zipentry.getName();
                if (!s1.startsWith(s) || !StrUtils.startsWith(s1 = s1.substring(s.length()), prefixes) || !StrUtils.endsWith(s1, suffixes)) continue;
                if (!ResUtils.isLowercase(s1)) {
                    Config.warn("Skipping non-lowercase path: " + s1);
                    continue;
                }
                list.add(s1);
            }
            zipfile.close();
            String[] astring = list.toArray(new String[list.size()]);
            return astring;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            return new String[0];
        }
    }

    private static boolean isLowercase(String str) {
        return str.equals(str.toLowerCase(Locale.ROOT));
    }

    public static Properties readProperties(String path, String module) {
        InputStream inputstream;
        block4: {
            ResourceLocation resourcelocation = new ResourceLocation(path);
            inputstream = Config.getResourceStream(resourcelocation);
            if (inputstream != null) break block4;
            return null;
        }
        try {
            PropertiesOrdered properties = new PropertiesOrdered();
            properties.load(inputstream);
            inputstream.close();
            Config.dbg(String.valueOf(module) + ": Loading " + path);
            return properties;
        }
        catch (FileNotFoundException filenotfoundexception) {
            return null;
        }
        catch (IOException ioexception) {
            Config.warn(String.valueOf(module) + ": Error reading " + path);
            return null;
        }
    }

    public static Properties readProperties(InputStream in, String module) {
        if (in == null) {
            return null;
        }
        try {
            PropertiesOrdered properties = new PropertiesOrdered();
            properties.load(in);
            in.close();
            return properties;
        }
        catch (FileNotFoundException filenotfoundexception) {
            return null;
        }
        catch (IOException ioexception) {
            return null;
        }
    }
}

